/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.eclipse.explodtwin.ui.dialogs;

import eu.fbk.tools.adapter.xsap.XsapFunction;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;

public class ComputeFaultTreeParametersDialog
extends Dialog {
    private Combo algorithmTypeCombo;
    private Text propertiesText;
    private Spinner boundLengthSpinner;
    private String[] algorithmTypes = new String[]{"bdd", "bmc", "ic3", "msat"};
    private boolean goAhead = false;
    private String properties;
    private int boundLength;
    private XsapFunction.AlgorithmType algorithmType;

    public ComputeFaultTreeParametersDialog(Shell parentShell) {
        super(parentShell);
        this.setShellStyle(48);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("FTA Parameters");
    }

    protected void okPressed() {
        this.algorithmType = XsapFunction.AlgorithmType.valueOf((String)this.algorithmTypeCombo.getItems()[this.algorithmTypeCombo.getSelectionIndex()]);
        this.properties = this.propertiesText.getText();
        this.boundLength = this.boundLengthSpinner.getSelection();
        this.goAhead = true;
        super.okPressed();
    }

    protected void cancelPressed() {
        this.goAhead = false;
        super.cancelPressed();
    }

    protected Control createDialogArea(Composite parent) {
        parent.setToolTipText("");
        Composite container = (Composite)super.createDialogArea(parent);
        Composite container2 = new Composite(container, 0);
        container2.setLayout((Layout)new GridLayout(2, false));
        container2.setLayoutData((Object)new GridData(768));
        Label lblProperties = new Label(container2, 0);
        lblProperties.setText("TLE Property");
        this.propertiesText = new Text(container2, 2052);
        this.propertiesText.setLayoutData((Object)new GridData(768));
        Label lblAlgorithm = new Label(container2, 0);
        lblAlgorithm.setText("Algorithm Type");
        this.algorithmTypeCombo = new Combo(container2, 8);
        this.algorithmTypeCombo.setLayoutData((Object)new GridData(768));
        this.setComboValues(this.algorithmTypeCombo, this.algorithmTypes);
        Label lblBoundLength = new Label(container2, 0);
        lblBoundLength.setText("Bound Length");
        this.boundLengthSpinner = new Spinner(container2, 2048);
        this.boundLengthSpinner.setLayoutData((Object)new GridData(768));
        this.boundLengthSpinner.setMinimum(0);
        this.boundLengthSpinner.setMaximum(50);
        this.boundLengthSpinner.setSelection(0);
        this.boundLengthSpinner.setIncrement(1);
        this.boundLengthSpinner.setPageIncrement(5);
        return container;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected Point getInitialSize() {
        return new Point(450, 200);
    }

    public boolean goAhead() {
        return this.goAhead;
    }

    private void setComboValues(Combo combo, String[] admittedValues) {
        combo.setItems(admittedValues);
        combo.select(3);
    }

    public String getProperties() {
        return this.properties;
    }

    public int getBoundLength() {
        return this.boundLength;
    }

    public String getAlgorithmType() {
        String type = this.algorithmType.toString();
        if ("ic3".equals(type)) {
            return null;
        }
        return type;
    }
}

