/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.eclipse.explodtwin.ui.dialogs;

import eu.fbk.sysmlv2.sysMLv2.NamedElement;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;

public class ElementSelectorDialog
extends Dialog {
    private List list;
    private String selection = null;
    private String text;
    private Button okButton;
    private Map<String, NamedElement> map = new LinkedHashMap<String, NamedElement>();
    private final String title;

    public ElementSelectorDialog(Shell parentShell, String title, String text) {
        super(parentShell);
        this.title = title;
        this.text = text;
    }

    public String getTitle() {
        return this.title;
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setText(this.title);
        Composite container = (Composite)super.createDialogArea(parent);
        GridLayout gridLayout = (GridLayout)container.getLayout();
        gridLayout.marginWidth = 10;
        gridLayout.marginHeight = 5;
        Label lblTitle = new Label(container, 0);
        lblTitle.setText(this.text);
        this.list = new List(container, 2816);
        GridData gd_list = new GridData(16384, 0x1000000, true, true, 1, 1);
        gd_list.heightHint = 130;
        gd_list.widthHint = 400;
        this.list.setLayoutData((Object)gd_list);
        this.map.values().forEach(p -> this.list.add(p.getName()));
        this.list.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String[] selections = ElementSelectorDialog.this.list.getSelection();
                if (selections == null || selections.length != 1) {
                    ElementSelectorDialog.this.selection = null;
                    ElementSelectorDialog.this.okButton.setEnabled(false);
                } else {
                    ElementSelectorDialog.this.selection = selections[0];
                    ElementSelectorDialog.this.okButton.setEnabled(true);
                }
            }
        });
        this.list.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                String[] selections = ElementSelectorDialog.this.list.getSelection();
                if (selections == null || selections.length != 1) {
                    ElementSelectorDialog.this.selection = null;
                    ElementSelectorDialog.this.okButton.setEnabled(false);
                } else {
                    ElementSelectorDialog.this.selection = selections[0];
                    ElementSelectorDialog.this.close();
                }
            }
        });
        this.list.pack();
        return container;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.okButton = this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.okButton.setEnabled(false);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected Point getInitialSize() {
        return new Point(450, 300);
    }

    public NamedElement getSelection() {
        if (this.selection == null) {
            return null;
        }
        return this.map.get(this.selection);
    }

    public void addElements(Collection<? extends NamedElement> elements) {
        elements.forEach(element -> {
            NamedElement namedElement = this.map.put(element.getName(), (NamedElement)element);
        });
    }
}

