/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.eclipse.explodtwin.ui.dialogs;

import eu.fbk.eclipse.explodtwin.api.core.ModelLibrary;
import eu.fbk.eclipse.explodtwin.api.util.ModelUtil;
import eu.fbk.sysmlv2.sysMLv2.Part;
import eu.fbk.sysmlv2.sysMLv2.PartUsage;
import eu.fbk.tools.adapter.nuxmv.CheckModel;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jface.widgets.CompositeFactory;
import org.eclipse.jface.widgets.WidgetFactory;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.xtext.EcoreUtil2;

public class ModelCheckingParametersDialog
extends eu.fbk.tools.adapter.ui.dialog.behaviour.ModelCheckingParametersDialog {
    protected Button fault;
    protected boolean faultModel;
    protected Boolean enableFault;
    private final List<PartUsage> subsystemsInstances;
    private final PartUsage selectedPartUsage;
    private final ModelLibrary modelLibrary = new ModelLibrary();
    private final boolean isExplodtwin;

    public ModelCheckingParametersDialog(Shell parentShell, String title, CheckModel function, Boolean asyncExecution, PartUsage selectedPartUsage, PartUsage system) {
        super(parentShell, title, function, asyncExecution);
        this.enableFault = selectedPartUsage == system;
        this.selectedPartUsage = selectedPartUsage;
        this.isExplodtwin = ModelUtil.isExplodtwin((ResourceSet)EcoreUtil2.getResourceSet((Notifier)system));
        this.subsystemsInstances = this.isExplodtwin ? this.modelLibrary.getSubsystems(this.modelLibrary.getRealAsset(system)) : List.of();
    }

    protected Control createBaseDialogArea(Composite parent) {
        GridLayout layout = new GridLayout();
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        Composite composite = (Composite)((CompositeFactory)((CompositeFactory)WidgetFactory.composite((int)0).layout((Layout)layout)).layoutData((Object)new GridData(1808))).create((Widget)parent);
        ModelCheckingParametersDialog.applyDialogFont((Control)composite);
        return composite;
    }

    protected Control createDialogArea(Composite parent) {
        parent.setToolTipText("");
        Composite container = (Composite)this.createBaseDialogArea(parent);
        this.timedDomainCheckBox = new Button(container, 32);
        this.timedDomainCheckBox.setText("Timed Domain");
        this.timedDomainCheckBox.setSelection(this.function.isTimed());
        this.timedDomainCheckBox.setEnabled(false);
        Composite container2 = new Composite(container, 0);
        container2.setLayout((Layout)new GridLayout(2, false));
        GridData gd_container2 = new GridData(4, 4, false, false);
        gd_container2.widthHint = 405;
        gd_container2.heightHint = 228;
        container2.setLayoutData((Object)gd_container2);
        Label lblCheck = new Label(container2, 0);
        lblCheck.setText("Check Type");
        GridData gd_comboCheckType = new GridData(16384, 0x1000000, true, false, 1, 1);
        gd_comboCheckType.widthHint = 289;
        this.comboCheckType = new Combo(container2, 8);
        this.comboCheckType.setLayoutData((Object)gd_comboCheckType);
        this.setComboValues(this.comboCheckType, this.checkTypes, this.function.getCheckType() == null ? "" : this.function.getCheckType().name());
        Label lblAlgorithm = new Label(container2, 0);
        lblAlgorithm.setText("Algorithm Type");
        GridData gd_comboAlgorithmType = new GridData(16384, 0x1000000, true, false, 1, 1);
        gd_comboAlgorithmType.widthHint = 286;
        this.comboAlgorithmType = new Combo(container2, 8);
        this.comboAlgorithmType.setLayoutData((Object)gd_comboAlgorithmType);
        this.setComboValues(this.comboAlgorithmType, this.algorithmTypes, this.function.getAlgorithmType() == null ? this.algorithmTypes[2] : this.function.getAlgorithmType().name());
        Label lblProperty = new Label(container2, 0);
        lblProperty.setText("Property");
        this.propertyText = new Text(container2, 2626);
        this.propertyText.setLayoutData((Object)new GridData(1808));
        if (!StringUtils.isBlank((CharSequence)this.function.getFormula())) {
            this.propertyText.setText(this.function.getFormula());
        }
        this.asyncCheckBox = new Button(container, 32);
        this.asyncCheckBox.setText("OSLC Asynchronous Execution");
        this.asyncCheckBox.setSelection(this.asyncExecution.booleanValue());
        this.asyncCheckBox.setVisible(false);
        this.fault = new Button(container, 32);
        this.fault.setText("Use model extended with faults (top level component must be selected)");
        this.fault.setSelection(false);
        this.fault.setEnabled(this.enableFault.booleanValue());
        this.fault.setToolTipText("The checkbox is enabled only if the top level component has been selected");
        new Label(container, 0);
        new Label(container, 0);
        new Label(container, 0);
        Composite container3 = new Composite(container, 0);
        GridLayout gl_container3 = new GridLayout(1, false);
        container3.setLayout((Layout)gl_container3);
        container3.setLayoutData((Object)new GridData(4, 4, false, false));
        return container;
    }

    public static List<String> findTokensPrefixingState(String input) {
        ArrayList<String> tokens = new ArrayList<String>();
        Pattern pattern = Pattern.compile("(\\w+)\\.State");
        Matcher matcher = pattern.matcher(input);
        while (matcher.find()) {
            tokens.add(matcher.group(1));
        }
        return tokens;
    }

    public static List<Integer> findUnprefixedState(String input) {
        Pattern pattern = Pattern.compile("(?<![\\\\dA-Za-z\\\\.])State|^State");
        Matcher matcher = pattern.matcher(input);
        ArrayList<Integer> indexes = new ArrayList<Integer>();
        while (matcher.find()) {
            indexes.add(matcher.start());
        }
        return indexes;
    }

    private String processProperty(String originalProperty) {
        Object property;
        block3: {
            List<Object> statePrefixes;
            block2: {
                List<Object> unprefixedStateIndices;
                property = originalProperty;
                statePrefixes = !ModelUtil.isSubsystem((Part)this.selectedPartUsage) ? ModelCheckingParametersDialog.findTokensPrefixingState((String)property) : List.of();
                List<Object> list = unprefixedStateIndices = ModelUtil.isSubsystem((Part)this.selectedPartUsage) ? ModelCheckingParametersDialog.findUnprefixedState((String)property) : List.of();
                if (unprefixedStateIndices.isEmpty()) break block2;
                for (Integer n : unprefixedStateIndices) {
                    property = ((String)property).substring(0, n) + this.modelLibrary.getMissionStateMachine(this.selectedPartUsage).getName() + "." + ((String)property).substring(n);
                }
                break block3;
            }
            if (statePrefixes.isEmpty()) break block3;
            for (String string : statePrefixes) {
                Optional<PartUsage> matchingSubsystem = this.subsystemsInstances.stream().filter(subsystem -> subsystem.getName().equals(prefix)).findAny();
                if (!matchingSubsystem.isPresent()) continue;
                PartUsage subsystem2 = matchingSubsystem.get();
                property = ((String)property).replace("." + string + ".State", "." + string + "." + this.modelLibrary.getMissionStateMachine(subsystem2).getName() + ".State");
            }
        }
        return property;
    }

    protected void okPressed() {
        this.faultModel = this.fault.getSelection();
        this.function.setTimed(this.timedDomainCheckBox.getSelection());
        if (this.isExplodtwin) {
            String processedProperty = this.processProperty(this.propertyText.getText());
            this.propertyText.setText(processedProperty);
        }
        super.okPressed();
    }

    public boolean isFaultModel() {
        return this.faultModel;
    }
}

