/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.eclipse.explodtwin.ui.dialogs;

import eu.fbk.eclipse.standardtools.utils.ui.utils.DirectoryUtil;
import eu.fbk.tools.adapter.xsap.XsapFunction;
import java.net.URL;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;
import org.osgi.framework.Bundle;

public class OptimizeObservablesParametersDialog
extends Dialog {
    private static final String PLUGIN_ID = "eu.fbk.eclipse.explodtwin";
    private Combo algorithmTypeCombo;
    private Spinner boundLengthSpinner;
    private String[] algorithmTypes = new String[]{"bmc", "bmc_ic3"};
    private boolean goAhead = false;
    private int boundLength;
    private XsapFunction.AlgorithmType algorithmType;
    private Text alarmFileText;
    private Text observablesFileText;
    private String alarmFile;
    private String observablesFile;
    private Shell shell;

    public OptimizeObservablesParametersDialog(Shell parentShell) {
        super(parentShell);
        this.shell = parentShell;
        this.setShellStyle(48);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Optimize Observables Parameters");
    }

    protected void okPressed() {
        this.algorithmType = XsapFunction.AlgorithmType.valueOf((String)this.algorithmTypeCombo.getItems()[this.algorithmTypeCombo.getSelectionIndex()]);
        this.boundLength = this.boundLengthSpinner.getSelection();
        this.alarmFile = this.alarmFileText.getText();
        this.observablesFile = this.observablesFileText.getText();
        this.goAhead = true;
        super.okPressed();
    }

    protected void cancelPressed() {
        this.goAhead = false;
        super.cancelPressed();
    }

    protected Control createDialogArea(Composite parent) {
        parent.setToolTipText("");
        Composite container = (Composite)super.createDialogArea(parent);
        Composite dialogContainer = new Composite(container, 0);
        dialogContainer.setLayout((Layout)new GridLayout(3, false));
        dialogContainer.setLayoutData((Object)new GridData(768));
        Label title1 = new Label(dialogContainer, 0);
        FontDescriptor boldDescriptor = FontDescriptor.createFrom((Font)title1.getFont()).setStyle(1);
        Font boldFont = boldDescriptor.createFont((Device)title1.getDisplay());
        title1.setFont(boldFont);
        title1.setText("Select the configuration files:");
        title1.setLayoutData((Object)new GridData(16384, 0x1000000, true, false, 3, 1));
        String filesPath = null;
        try {
            filesPath = DirectoryUtil.getInstance().getCurrentProjectDir();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.alarmFileText = this.prepareConfigPathGraphicalComponents(dialogContainer, "Select the alarm file", filesPath, "*.asl");
        this.observablesFileText = this.prepareConfigPathGraphicalComponents(dialogContainer, "Select the observables file", filesPath, "*.obs");
        Label emptyLine = new Label(dialogContainer, 256);
        emptyLine.setLayoutData((Object)new GridData(4, 4, true, false, 3, 1));
        Label title2 = new Label(dialogContainer, 0);
        title2.setFont(boldFont);
        title2.setText("Configure the engine:");
        title2.setLayoutData((Object)new GridData(16384, 0x1000000, true, false, 3, 1));
        Label lblAlgorithm = new Label(dialogContainer, 0);
        lblAlgorithm.setText("Algorithm Type");
        lblAlgorithm.setLayoutData((Object)new GridData(16384, 0x1000000, true, false, 2, 1));
        this.algorithmTypeCombo = new Combo(dialogContainer, 8);
        this.algorithmTypeCombo.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.setComboValues(this.algorithmTypeCombo, this.algorithmTypes);
        this.algorithmTypeCombo.select(0);
        Label lblBoundLength = new Label(dialogContainer, 0);
        lblBoundLength.setText("Bound Length");
        lblBoundLength.setLayoutData((Object)new GridData(16384, 0x1000000, true, false, 2, 1));
        this.boundLengthSpinner = new Spinner(dialogContainer, 2048);
        this.boundLengthSpinner.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.boundLengthSpinner.setMinimum(0);
        this.boundLengthSpinner.setMaximum(100);
        this.boundLengthSpinner.setSelection(10);
        this.boundLengthSpinner.setIncrement(1);
        this.boundLengthSpinner.setPageIncrement(10);
        return container;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected Point getInitialSize() {
        return new Point(500, 300);
    }

    private void setComboValues(Combo combo, String[] admittedValues) {
        combo.setItems(admittedValues);
    }

    private Text prepareConfigPathGraphicalComponents(Composite container, String labelText, final String defaultPath, final String extension) {
        Bundle bundle = Platform.getBundle((String)PLUGIN_ID);
        URL urlBrowseImage = FileLocator.find((Bundle)bundle, (IPath)new Path("icons/elipses.gif"), null);
        Image browseImage = ImageDescriptor.createFromURL((URL)urlBrowseImage).createImage();
        Label confFilePathLabel = new Label(container, 0);
        confFilePathLabel.setText(labelText);
        Button browseConfFilePath = new Button(container, 8);
        browseConfFilePath.setImage(browseImage);
        browseConfFilePath.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        final Text confFilePath = new Text(container, 4);
        confFilePath.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        GridData d = new GridData(4, 0x1000000, false, false, 1, 1);
        d.widthHint = 250;
        confFilePath.setLayoutData((Object)d);
        browseConfFilePath.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                switch (e.type) {
                    case 13: {
                        try {
                            String pathFromDialog = OptimizeObservablesParametersDialog.this.getFileNameFromDialog("Choose the file", defaultPath, extension);
                            if (pathFromDialog == null) break;
                            confFilePath.setText(pathFromDialog);
                            break;
                        }
                        catch (Exception e1) {
                            e1.printStackTrace();
                        }
                    }
                }
            }
        });
        return confFilePath;
    }

    private String getFileNameFromDialog(String title, String defaultPath, String filterExtension) throws Exception {
        FileDialog fileDialog = new FileDialog(this.shell);
        fileDialog.setText(title);
        fileDialog.setFilterPath(defaultPath);
        if (filterExtension != null) {
            String[] extensions = new String[]{filterExtension};
            fileDialog.setFilterExtensions(extensions);
        }
        String directoryName = fileDialog.open();
        return directoryName;
    }

    public boolean goAhead() {
        return this.goAhead;
    }

    public int getBoundLength() {
        return this.boundLength;
    }

    public String getAlgorithmType() {
        return this.algorithmType.toString();
    }

    public String getObservablesPath() {
        return this.observablesFile;
    }

    public String getAlarmPath() {
        return this.alarmFile;
    }
}

