/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.eclipse.explodtwin.util;

import eu.fbk.eclipse.explodtwin.api.core.SysMLv2StateMachineModel;
import eu.fbk.eclipse.explodtwin.api.core.SysMLv2SystemModel;
import eu.fbk.eclipse.explodtwin.api.util.ModelUtil;
import eu.fbk.eclipse.explodtwin.ui.dialogs.ElementSelectorDialog;
import eu.fbk.eclipse.standardTools.XSapExecService.services.XSapExecService;
import eu.fbk.eclipse.standardtools.ModelTranslatorToOcra.ui.services.OSSTranslatorServiceUI;
import eu.fbk.eclipse.standardtools.StateMachineTranslatorToSmv.core.services.FeiTranslatorServiceAPI;
import eu.fbk.eclipse.standardtools.StateMachineTranslatorToSmv.core.services.SMVTranslatorServiceAPI;
import eu.fbk.eclipse.standardtools.StateMachineTranslatorToSmv.core.utils.SmvModelUtil;
import eu.fbk.eclipse.standardtools.nuXmvService.ui.utils.NuXmvDirectoryUtil;
import eu.fbk.eclipse.standardtools.utils.core.model.AbstractStateMachineModel;
import eu.fbk.eclipse.standardtools.utils.core.model.AbstractSystemModel;
import eu.fbk.eclipse.standardtools.utils.core.utils.FileSystemUtil;
import eu.fbk.eclipse.standardtools.utils.core.utils.Pair;
import eu.fbk.eclipse.standardtools.utils.ui.utils.DialogUtil;
import eu.fbk.eclipse.standardtools.utils.ui.utils.DirectoryUtil;
import eu.fbk.eclipse.standardtools.utils.ui.utils.ErrorsDialogUtil;
import eu.fbk.eclipse.standardtools.utils.ui.utils.OCRADirectoryUtil;
import eu.fbk.eclipse.standardtools.xtextService.core.utils.XTextResourceUtil;
import eu.fbk.sysmlv2.sysMLv2.ConnectionElement;
import eu.fbk.sysmlv2.sysMLv2.DirectedElement;
import eu.fbk.sysmlv2.sysMLv2.Part;
import eu.fbk.sysmlv2.sysMLv2.PartDefinition;
import eu.fbk.sysmlv2.sysMLv2.PartUsage;
import eu.fbk.sysmlv2.sysMLv2.QualifiedNameExpression;
import eu.fbk.sysmlv2.sysMLv2.StateUsage;
import eu.fbk.sysmlv2.sysMLv2.Usage;
import eu.fbk.sysmlv2.util.SysMLv2Util;
import eu.fbk.tools.adapter.ui.Activator;
import eu.fbk.tools.adapter.ui.commands.contract.PrintSystemImplementationCommand;
import eu.fbk.tools.editor.basetype.baseType.Expression;
import eu.fbk.tools.editor.nusmv.smv.ComplexIdentifier;
import eu.fbk.tools.editor.nusmv.smv.DefineBody;
import eu.fbk.tools.editor.nusmv.smv.DefineDeclaration;
import eu.fbk.tools.editor.nusmv.smv.FunBody;
import eu.fbk.tools.editor.nusmv.smv.FunctionDeclaration;
import eu.fbk.tools.editor.nusmv.smv.IVariableDeclaration;
import eu.fbk.tools.editor.nusmv.smv.Model;
import eu.fbk.tools.editor.nusmv.smv.Module;
import eu.fbk.tools.editor.nusmv.smv.ModuleElement;
import eu.fbk.tools.editor.nusmv.smv.ModuleParameter;
import eu.fbk.tools.editor.nusmv.smv.ModuleType;
import eu.fbk.tools.editor.nusmv.smv.SmvFactory;
import eu.fbk.tools.editor.nusmv.smv.TimeAnnotation;
import eu.fbk.tools.editor.nusmv.smv.VarBody;
import eu.fbk.tools.editor.nusmv.smv.VariableDeclaration;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.resource.XtextResourceSet;

public class AdapterUtil {
    private static final String SM_SUFFIX = "_SM";
    private static final String MAIN = "main";
    private static final SmvFactory SMV_FACTORY = SmvFactory.eINSTANCE;
    private static final String ID_PARAMETER_MAP_FILE_PATH = "map_file";
    private static final String ID_PARAMETER_MODEL_FILE_OSS_PATH = "contract_model";
    private static final String ID_PARAMETER_MODEL_TIME = "time_model";
    private static final String ID_PARAMETER_RESULT_FILE = "result_file";
    private static final String ID_PARAMETER_USE_OLD_MODEL = "old_model_format";
    private static final String ID_INTERNAL_EXECUTION = "internal_execution";
    private static final String ID_DISABLE_ASYNC_CONSTRAINTS = "disable_async_constraints";
    private static final String SMV_EXT = ".smv";
    private static final String FEI_EXT = ".fei";
    private static final String XML_EXT = ".xml";
    private static final String RESULTS_FILE_PATH = File.separator + "VerificationResults";
    private static final SysMLv2SystemModel SYSTEM_MODEL = new SysMLv2SystemModel();
    private static final SysMLv2StateMachineModel STATE_MACHINE_MODEL = new SysMLv2StateMachineModel();

    public static Resource getResource(IFile iFile) {
        if (iFile.getFileExtension().equalsIgnoreCase("sysml")) {
            XtextResourceSet resourceSet = new XtextResourceSet();
            resourceSet.addLoadOption((Object)XtextResource.OPTION_ENCODING, (Object)"UTF-8");
            Resource resource = resourceSet.getResource(URI.createFileURI((String)iFile.getLocation().toOSString()), true);
            if (resource == null) {
                return null;
            }
            return resource;
        }
        return null;
    }

    public static IProject initProject(String projectName) throws ExecutionException {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        NullProgressMonitor monitor = new NullProgressMonitor();
        if (project == null) {
            throw new ExecutionException("Can't get project '" + projectName + "' from workspace.");
        }
        if (project.exists()) {
            try {
                project.delete(true, (IProgressMonitor)monitor);
            }
            catch (CoreException e) {
                throw new ExecutionException("Can't delete project '" + projectName + "'.", (Throwable)e);
            }
        }
        try {
            project.create((IProgressMonitor)monitor);
        }
        catch (CoreException e) {
            throw new ExecutionException("Can't create project '" + projectName + "'.", (Throwable)e);
        }
        if (!project.isOpen()) {
            try {
                project.open(null);
            }
            catch (CoreException e) {
                throw new ExecutionException("Can't open project '" + projectName + "'.", (Throwable)e);
            }
        }
        return project;
    }

    public static String generateOCRA(PartUsage systemComponent, int timeSpecification) {
        OSSTranslatorServiceUI ossTranslatorService = OSSTranslatorServiceUI.getInstance((AbstractSystemModel)SYSTEM_MODEL);
        String workspaceDir = Activator.getDefault().getPreferenceStore().getString("tools.workspace");
        boolean showPopups = false;
        boolean isAsyncCommunication = true;
        boolean useXtextValidation = true;
        System.out.println("workspaceDir = " + workspaceDir);
        try {
            File ossFile = ossTranslatorService.exportRootComponentToOssFile((Object)systemComponent, systemComponent.eResource(), timeSpecification, isAsyncCommunication, useXtextValidation, showPopups, workspaceDir, (IProgressMonitor)new NullProgressMonitor());
            System.out.println("OSS file = " + ossFile.getAbsolutePath());
            return ossFile.getAbsolutePath();
        }
        catch (Exception e) {
            DialogUtil.getInstance().showMessage_ExceptionError(e);
            e.printStackTrace();
            return null;
        }
    }

    public static String generateSMV(PartUsage selectedPart, int timeSpecification) {
        String workspaceDir = Activator.getDefault().getPreferenceStore().getString("tools.workspace");
        OCRADirectoryUtil ocraDirectoryUtil = OCRADirectoryUtil.getInstance();
        NuXmvDirectoryUtil nuXmvDirectoryUtil = NuXmvDirectoryUtil.getInstance();
        OSSTranslatorServiceUI ossTranslatorServiceUI = OSSTranslatorServiceUI.getInstance((AbstractSystemModel)SYSTEM_MODEL);
        NullProgressMonitor monitor = new NullProgressMonitor();
        boolean showPopups = false;
        boolean internalExecution = true;
        boolean isAsyncCommunication = true;
        boolean useXtextValidation = true;
        boolean disableAsyncConstraints = false;
        String default_USE_OLD_MODEL = "false";
        String model_time = null;
        try {
            if (SysMLv2Util.isSystemPartUsage((PartUsage)selectedPart)) {
                HashMap<String, String> smvPathComponentNameMap = new HashMap<String, String>();
                for (PartDefinition component : SYSTEM_MODEL.getComponents((Object)selectedPart)) {
                    String smvFile = AdapterUtil.GenerateSingleSMV((Part)component, workspaceDir, (IProgressMonitor)monitor, timeSpecification);
                    if (smvFile == null) continue;
                    String compName = SYSTEM_MODEL.getComponentName((Object)component);
                    smvPathComponentNameMap.put(smvFile, compName);
                }
                String ossDirPath = ocraDirectoryUtil.getOSSDirPath();
                String smvMapDirPath = nuXmvDirectoryUtil.getSmvFileDirectory();
                String monolithicSMVFilePath = nuXmvDirectoryUtil.getMonolithicSMVFilePath(selectedPart.getName());
                System.out.println("ossDirPath = " + ossDirPath);
                System.out.println("smvMapDirPath = " + smvMapDirPath);
                System.out.println("monolithicSMVFilePath = " + monolithicSMVFilePath);
                File smvMapFile = FileSystemUtil.createSmvMapFile((String)"map", (String)smvMapDirPath, smvPathComponentNameMap);
                System.out.println("smvMapFile = " + String.valueOf(smvMapFile));
                File ossFile = ossTranslatorServiceUI.exportRootComponentToOssFile((Object)selectedPart, selectedPart.eResource(), timeSpecification, isAsyncCommunication, useXtextValidation, showPopups, ossDirPath, (IProgressMonitor)monitor);
                switch (timeSpecification) {
                    case 0: {
                        model_time = "hybrid";
                        break;
                    }
                    case 1: {
                        model_time = "discrete";
                        break;
                    }
                    case 2: {
                        model_time = "timed";
                    }
                }
                Map<String, String> parameters = Map.of(ID_PARAMETER_MODEL_FILE_OSS_PATH, ossFile.getPath(), ID_PARAMETER_MAP_FILE_PATH, smvMapFile.getPath(), ID_PARAMETER_MODEL_TIME, model_time, ID_PARAMETER_USE_OLD_MODEL, default_USE_OLD_MODEL, ID_INTERNAL_EXECUTION, String.valueOf(internalExecution), ID_PARAMETER_RESULT_FILE, monolithicSMVFilePath, ID_DISABLE_ASYNC_CONSTRAINTS, String.valueOf(disableAsyncConstraints));
                ExecutionEvent event = new ExecutionEvent(null, parameters, null, null);
                PrintSystemImplementationCommand cmd = new PrintSystemImplementationCommand();
                try {
                    cmd.execute(event);
                }
                catch (ExecutionException e) {
                    e.printStackTrace();
                }
                return monolithicSMVFilePath;
            }
            return AdapterUtil.GenerateSingleSMV((Part)selectedPart, workspaceDir, (IProgressMonitor)monitor, timeSpecification);
        }
        catch (Exception e) {
            DialogUtil.getInstance().showMessage_ExceptionError(e);
            e.printStackTrace();
            return null;
        }
    }

    private static String GenerateSingleSMV(Part component, String workspaceDir, IProgressMonitor monitor, int timeSpecification) throws Exception {
        File smvFile = null;
        SMVTranslatorServiceAPI smvTranslatorServiceAPI = SMVTranslatorServiceAPI.getInstance((AbstractSystemModel)SYSTEM_MODEL, (AbstractStateMachineModel)STATE_MACHINE_MODEL);
        if (ModelUtil.isSubsystem((Part)component)) {
            HashMap<String, String> smvPathComponentNameMap = new HashMap<String, String>();
            Set stateMachines = STATE_MACHINE_MODEL.getNominalStateMachinesIncludingFromSubComponents((Object)component);
            for (StateUsage stateMachine : stateMachines) {
                String fsmName = STATE_MACHINE_MODEL.getStateMachineName((Object)stateMachine);
                smvFile = smvTranslatorServiceAPI.exportStateMachineToSmvFile((Object)stateMachine, workspaceDir, fsmName, monitor, timeSpecification);
                smvPathComponentNameMap.put(smvFile.getPath(), fsmName);
                System.out.println("Storing " + fsmName + " in " + smvFile.getPath());
            }
            StateUsage missionStateMachine = ModelUtil.getMissionStateMachine((Part)component);
            String timeAnnotation = "continuous";
            return AdapterUtil.composeSMV(smvPathComponentNameMap, workspaceDir, monitor, missionStateMachine, timeAnnotation, component);
        }
        Object stateMachine = STATE_MACHINE_MODEL.getFirstNominalStateMachine((Object)component);
        if (stateMachine == null) {
            return null;
        }
        String compName = SYSTEM_MODEL.getComponentName((Object)component);
        smvFile = smvTranslatorServiceAPI.exportStateMachineToSmvFile(stateMachine, workspaceDir, compName, monitor, timeSpecification);
        return smvFile != null ? smvFile.getPath() : null;
    }

    private static String composeSMV(Map<String, String> smvPathComponentNameMap, String workspaceDir, IProgressMonitor monitor, StateUsage missionStateMachine, String timeSpecification, Part component) throws Exception {
        EList<DefineBody> mainDefineBodies;
        XTextResourceUtil xtextResourceUtil = XTextResourceUtil.getInstance();
        ArrayList<Module> subModules = new ArrayList<Module>();
        ArrayList<Module> mains = new ArrayList<Module>();
        String compInstanceName = SYSTEM_MODEL.getComponentName((Object)component);
        String compTypeName = SYSTEM_MODEL.getComponentTypeName((Object)component);
        String compModuleName = component instanceof PartUsage ? compTypeName : compInstanceName;
        String missionName = STATE_MACHINE_MODEL.getStateMachineName((Object)missionStateMachine);
        Module moduleSubsysModule = null;
        for (Map.Entry<String, String> entry : smvPathComponentNameMap.entrySet()) {
            Object content = "";
            try {
                content = Files.readString(Paths.get(entry.getKey(), new String[0]));
            }
            catch (IOException e) {
                System.err.println("Error reading file: " + e.getMessage());
            }
            Model smvModel = xtextResourceUtil.deserializeSmvModel((String)content);
            for (Module module : smvModel.getModules()) {
                if (module.getIdentifier().equals(MAIN)) {
                    mains.add(module);
                    continue;
                }
                subModules.add(module);
                if (!module.getIdentifier().equals(compTypeName)) continue;
                moduleSubsysModule = (Module)EcoreUtil.copy((EObject)module);
            }
        }
        HashMap<String, String> instances = new HashMap<String, String>();
        for (PartUsage instance : EcoreUtil2.typeSelect((List)ModelUtil.getComponentType((Part)component).getMembers(), PartUsage.class)) {
            instances.put(SYSTEM_MODEL.getName((Object)instance), SYSTEM_MODEL.getComponentInstanceTypeName((Object)instance));
        }
        instances.put(missionName, compTypeName);
        HashMap<String, VarBody> moduleInstances = new HashMap<String, VarBody>();
        HashMap<String, BasicEList> functions = new HashMap<String, BasicEList>();
        Module mainSubsysModule = null;
        for (Module module : mains) {
            for (Iterator variable : AdapterUtil.extractVarBodies(module)) {
                if (!(variable.getType() instanceof ModuleType)) continue;
                String moduleType = variable.getIdentifier().getIdentifier().getValue();
                BasicEList moduleFunctions = new BasicEList();
                for (FunBody function : AdapterUtil.extractFunBodies(module)) {
                    moduleFunctions.add((Object)((FunBody)EcoreUtil.copy((EObject)function)));
                }
                functions.put(moduleType, moduleFunctions);
                moduleInstances.put(moduleType, (VarBody)EcoreUtil.copy((EObject)variable));
                if (!variable.getIdentifier().getIdentifier().getValue().equals(compTypeName)) continue;
                mainSubsysModule = (Module)EcoreUtil.copy((EObject)module);
            }
        }
        HashMap<String, String> connectionsMap = new HashMap<String, String>();
        for (ConnectionElement connection : ModelUtil.getConnectionsPorts((Part)component)) {
            Object connSource = SYSTEM_MODEL.getConnectorSource((Object)connection);
            String sourceEndName = SYSTEM_MODEL.getConnectorEndName(connSource);
            Object connTarget = SYSTEM_MODEL.getConnectorTarget((Object)connection);
            String targetEndName = SYSTEM_MODEL.getConnectorEndName(connTarget);
            boolean isOut = false;
            if (connSource instanceof QualifiedNameExpression) {
                QualifiedNameExpression expr = (QualifiedNameExpression)connSource;
                isOut = ModelUtil.isOutputParameter((Object)expr.getReferencedElement());
            }
            String prefix = AdapterUtil.getConnectorOwnerName(SYSTEM_MODEL.getConnectorEndOwner(connSource));
            if (isOut && prefix == null) {
                prefix = missionName;
            }
            String source = prefix == null ? sourceEndName : prefix + "." + sourceEndName;
            boolean isIn = false;
            if (connTarget instanceof QualifiedNameExpression) {
                QualifiedNameExpression expr = (QualifiedNameExpression)connTarget;
                isIn = ModelUtil.isInputParameter((Object)expr.getReferencedElement());
            }
            prefix = AdapterUtil.getConnectorOwnerName(SYSTEM_MODEL.getConnectorEndOwner(connTarget));
            if (isIn && prefix == null) {
                prefix = missionName;
            }
            String target = prefix == null ? targetEndName : prefix + "." + (String)targetEndName;
            connectionsMap.put(target, source);
        }
        List<String> internalVars = AdapterUtil.computeInternalVar((EObject)component, missionStateMachine, SYSTEM_MODEL, STATE_MACHINE_MODEL);
        Module subsystemModule = SMV_FACTORY.createModule();
        subsystemModule.setIdentifier(compModuleName);
        subsystemModule.getModuleParameters().addAll((Collection)moduleSubsysModule.getModuleParameters());
        subsystemModule = AdapterUtil.removeInternalVarsFromModule(subsystemModule, internalVars);
        BasicEList qualifiedFunctions = new BasicEList();
        VariableDeclaration varDeclaration = SMV_FACTORY.createVariableDeclaration();
        for (String instanceName : instances.keySet()) {
            VarBody varBody = (VarBody)EcoreUtil.copy((EObject)((VarBody)moduleInstances.get(instances.get(instanceName))));
            varBody.getIdentifier().getIdentifier().setValue(instanceName);
            EList<FunBody> moduleFunctions = (EList<FunBody>)functions.get(instances.get(instanceName));
            moduleFunctions = AdapterUtil.qualifyFunctions(moduleFunctions, instanceName);
            qualifiedFunctions.addAll(moduleFunctions);
            VarBody moduleInstance = AdapterUtil.createInstance(instanceName, varBody, connectionsMap, compTypeName, moduleFunctions);
            varDeclaration.getVariables().add((Object)moduleInstance);
        }
        subsystemModule.getModuleElements().add((Object)varDeclaration);
        EList<DefineBody> defineBodies = AdapterUtil.renameDefineBodies(AdapterUtil.extractDefineBodies(mainSubsysModule), missionName, connectionsMap);
        if (!defineBodies.isEmpty()) {
            DefineDeclaration defines = SMV_FACTORY.createDefineDeclaration();
            defines.getBodies().addAll(defineBodies);
            subsystemModule.getModuleElements().add((Object)defines);
        }
        if (!qualifiedFunctions.isEmpty()) {
            FunctionDeclaration functionDeclarations = SMV_FACTORY.createFunctionDeclaration();
            functionDeclarations.getVariables().addAll((Collection)qualifiedFunctions);
            subsystemModule.getModuleElements().add((Object)functionDeclarations);
        }
        Module mainModule = SMV_FACTORY.createModule();
        mainModule.setIdentifier(MAIN);
        VariableDeclaration mainVarDeclaration = SMV_FACTORY.createVariableDeclaration();
        VarBody varBody = (VarBody)EcoreUtil.copy((EObject)((VarBody)moduleInstances.get(compModuleName)));
        varBody.getIdentifier().getIdentifier().setValue(compModuleName);
        varBody = AdapterUtil.removeInternalVarsFromParameters(varBody, internalVars);
        mainVarDeclaration.getVariables().add((Object)varBody);
        mainModule.getModuleElements().add((Object)mainVarDeclaration);
        EList<VarBody> varBodies = AdapterUtil.extractVarBodies(mainSubsysModule);
        varBodies = AdapterUtil.removeInternalVarsFromVars(varBodies, internalVars);
        VariableDeclaration mainVars = SMV_FACTORY.createVariableDeclaration();
        for (VarBody body : varBodies) {
            if (body.getType() instanceof ModuleType) continue;
            mainVars.getVariables().add((Object)body);
        }
        if (!mainVars.getVariables().isEmpty()) {
            mainModule.getModuleElements().add((Object)mainVars);
        }
        EList<VarBody> ivarBodies = AdapterUtil.extractIvarBodies(mainSubsysModule);
        if (!(ivarBodies = AdapterUtil.removeInternalVarsFromVars(ivarBodies, internalVars)).isEmpty()) {
            IVariableDeclaration mainIvars = SMV_FACTORY.createIVariableDeclaration();
            mainIvars.getVariables().addAll(ivarBodies);
            mainModule.getModuleElements().add((Object)mainIvars);
        }
        if (!(mainDefineBodies = AdapterUtil.renameDefineBodies(AdapterUtil.extractDefineBodies(mainSubsysModule), compModuleName, Map.of())).isEmpty()) {
            DefineDeclaration mainDefines = SMV_FACTORY.createDefineDeclaration();
            mainDefines.getBodies().addAll(mainDefineBodies);
            mainModule.getModuleElements().add((Object)mainDefines);
        }
        Model finalModel = xtextResourceUtil.deserializeSmvModel("MODULE dummy\n");
        finalModel.getModules().clear();
        TimeAnnotation timeAnnotation = SMV_FACTORY.createTimeAnnotation();
        timeAnnotation.setValue(timeSpecification);
        finalModel.setAnnotation(timeAnnotation);
        finalModel.getModules().add((Object)mainModule);
        finalModel.getModules().add((Object)subsystemModule);
        for (Module module : subModules) {
            if (module.getIdentifier().equals(moduleSubsysModule.getIdentifier())) {
                module = AdapterUtil.changeModuleName(module);
            }
            finalModel.getModules().add((Object)((Module)EcoreUtil.copy((EObject)module)));
        }
        File smvFile = SmvModelUtil.getInstance().generateSmvFileFromSmvModel(workspaceDir, compInstanceName, (Object)finalModel, monitor);
        return smvFile.getPath();
    }

    private static EList<FunBody> qualifyFunctions(EList<FunBody> moduleFunctions, String funPrefix) throws Exception {
        BasicEList qualifiedFunctions = new BasicEList();
        for (FunBody function : moduleFunctions) {
            Expression expr = AdapterUtil.createSMVExpression("_" + funPrefix + "." + function.getIdentifier().getIdentifier().getValue());
            FunBody qualified = (FunBody)EcoreUtil.copy((EObject)function);
            qualified.setIdentifier((ComplexIdentifier)expr);
            qualifiedFunctions.add((Object)qualified);
        }
        return qualifiedFunctions;
    }

    private static List<String> computeInternalVar(EObject component, StateUsage missionStateMachine, SysMLv2SystemModel systemModel, SysMLv2StateMachineModel stateMachineModel) {
        ArrayList<String> internalVars = new ArrayList<String>();
        EList inports = systemModel.getNonStaticInputPorts((Object)component);
        EList statePorts = stateMachineModel.getOwnerInputPortsExceptEvents((Object)missionStateMachine);
        statePorts.addAll((Collection)stateMachineModel.getOwnerInputEvents((Object)missionStateMachine));
        statePorts.removeAll((Collection)inports);
        for (DirectedElement directedElement : statePorts) {
            internalVars.add(directedElement.getName());
        }
        return internalVars;
    }

    private static Module removeInternalVarsFromModule(Module module, List<String> internalVars) {
        Module updatedModule = (Module)EcoreUtil.copy((EObject)module);
        updatedModule.getModuleParameters().clear();
        for (ModuleParameter parameter : module.getModuleParameters()) {
            if (internalVars.contains(parameter.getIdentifier())) continue;
            updatedModule.getModuleParameters().add((Object)((ModuleParameter)EcoreUtil.copy((EObject)parameter)));
        }
        return updatedModule;
    }

    private static EList<VarBody> removeInternalVarsFromVars(EList<VarBody> varBodies, List<String> internalVars) {
        BasicEList updatedList = new BasicEList();
        for (VarBody varBody : varBodies) {
            if (internalVars.contains(varBody.getIdentifier().getIdentifier().getValue())) continue;
            updatedList.add((Object)((VarBody)EcoreUtil.copy((EObject)varBody)));
        }
        return updatedList;
    }

    private static VarBody removeInternalVarsFromParameters(VarBody varBody, List<String> internalVars) {
        VarBody updatedVar = (VarBody)EcoreUtil.copy((EObject)varBody);
        ModuleType type = (ModuleType)updatedVar.getType();
        type.getParams().clear();
        for (Expression param : ((ModuleType)varBody.getType()).getParams()) {
            ComplexIdentifier identifier;
            if (!(param instanceof ComplexIdentifier) || internalVars.contains((identifier = (ComplexIdentifier)param).getIdentifier().getValue())) continue;
            type.getParams().add((Object)((Expression)EcoreUtil.copy((EObject)param)));
        }
        return updatedVar;
    }

    private static Module changeModuleName(Module module) {
        Module renamed = (Module)EcoreUtil.copy((EObject)module);
        renamed.setIdentifier(module.getIdentifier() + SM_SUFFIX);
        return renamed;
    }

    private static <T extends EObject, R> EList<R> extractBodies(Module module, Class<T> declarationClass, Function<T, EList<R>> extractor) {
        BasicEList bodies = new BasicEList();
        for (ModuleElement element : module.getModuleElements()) {
            if (!declarationClass.isInstance(element)) continue;
            EObject declaration = (EObject)declarationClass.cast(element);
            bodies.addAll((Collection)extractor.apply(declaration));
        }
        return bodies;
    }

    private static EList<DefineBody> extractDefineBodies(Module subSysModule) {
        return AdapterUtil.extractBodies(subSysModule, DefineDeclaration.class, DefineDeclaration::getBodies);
    }

    private static EList<VarBody> extractVarBodies(Module subSysModule) {
        return AdapterUtil.extractBodies(subSysModule, VariableDeclaration.class, VariableDeclaration::getVariables);
    }

    private static EList<VarBody> extractIvarBodies(Module subSysModule) {
        return AdapterUtil.extractBodies(subSysModule, IVariableDeclaration.class, IVariableDeclaration::getVariables);
    }

    private static EList<FunBody> extractFunBodies(Module subSysModule) {
        return AdapterUtil.extractBodies(subSysModule, FunctionDeclaration.class, FunctionDeclaration::getVariables);
    }

    private static EList<DefineBody> renameDefineBodies(EList<DefineBody> bodies, String newPrefix, Map<String, String> connections) {
        BasicEList adaptedBodies = new BasicEList();
        for (DefineBody body : bodies) {
            DefineBody adapted = (DefineBody)EcoreUtil.copy((EObject)body);
            String variableName = adapted.getVariable().getIdentifier().getValue();
            Expression expression = adapted.getExpression();
            if (expression instanceof ComplexIdentifier) {
                ComplexIdentifier complexId = (ComplexIdentifier)expression;
                String[] connectionSource = connections.entrySet().stream().filter(entry -> ((String)entry.getKey()).equals(variableName)).map(Map.Entry::getValue).map(source -> source.split("\\.")).filter(array -> ((String[])array).length == 2).findAny().orElse(new String[]{newPrefix, variableName});
                complexId.getLeft().getIdentifier().setValue(connectionSource[0]);
                ((ComplexIdentifier)complexId.getRight()).getIdentifier().setValue(connectionSource[1]);
            }
            adaptedBodies.add((Object)adapted);
        }
        return adaptedBodies;
    }

    private static String getConnectorOwnerName(Object connectorEndOwner) {
        String string;
        if (connectorEndOwner instanceof PartUsage) {
            PartUsage usage = (PartUsage)connectorEndOwner;
            string = usage.getName();
        } else {
            string = null;
        }
        return string;
    }

    private static VarBody createInstance(String instanceName, VarBody variable, Map<String, String> conns, String compTypeName, EList<FunBody> moduleFunctions) throws Exception {
        EObject eObject = variable.getType();
        if (eObject instanceof ModuleType) {
            ModuleType moduleType = (ModuleType)eObject;
            ModuleType varType = SMV_FACTORY.createModuleType();
            Object moduleTypeName = moduleType.getIdentifier();
            if (((String)moduleTypeName).equals(compTypeName)) {
                moduleTypeName = (String)moduleTypeName + SM_SUFFIX;
            }
            varType.setIdentifier((String)moduleTypeName);
            for (Expression param : moduleType.getParams()) {
                if (param instanceof ComplexIdentifier) {
                    ComplexIdentifier identifier = (ComplexIdentifier)param;
                    String paramName = identifier.getIdentifier().getValue();
                    String identifierName = instanceName + "." + paramName;
                    Expression expr = AdapterUtil.createSMVExpression(conns.get(identifierName));
                    if (expr != null) {
                        varType.getParams().add((Object)expr);
                        continue;
                    }
                    expr = AdapterUtil.createSMVExpression(AdapterUtil.getQualifiedFunction(paramName, moduleFunctions));
                    if (expr != null) {
                        varType.getParams().add((Object)expr);
                        continue;
                    }
                    varType.getParams().add((Object)((Expression)EcoreUtil.copy((EObject)param)));
                    continue;
                }
                System.err.println("Type of module parameter not supported.");
            }
            variable.setType(EcoreUtil.copy((EObject)varType));
            return variable;
        }
        return null;
    }

    private static String getQualifiedFunction(String paramName, EList<FunBody> moduleFunctions) {
        for (FunBody function : moduleFunctions) {
            if (!paramName.equals(((ComplexIdentifier)function.getIdentifier().getRight()).getIdentifier().getValue())) continue;
            return function.getIdentifier().getLeft().getIdentifier().getValue() + "." + paramName;
        }
        return null;
    }

    private static Expression createSMVExpression(String expression) throws Exception {
        if (expression != null) {
            String modelBody = "MODULE main VAR instance : Type ( " + expression + ");";
            Model smvModel = XTextResourceUtil.getInstance().deserializeSmvModel(modelBody);
            List varType = EcoreUtil2.getAllContentsOfType((EObject)smvModel, ModuleType.class);
            return (Expression)((ModuleType)varType.get(0)).getParams().get(0);
        }
        return null;
    }

    public static Pair<Usage, String> processSysMLModel(Resource resource, Shell activeShell, int timeSpecification) {
        PartUsage system;
        if (resource.getContents().size() != 1) {
            return null;
        }
        EObject rootElement = (EObject)resource.getContents().get(0);
        List partUsages = ModelUtil.getAllContentsOfTypeFromModel((ResourceSet)EcoreUtil2.getResourceSet((Notifier)rootElement), PartUsage.class);
        if (partUsages.isEmpty()) {
            return null;
        }
        partUsages.sort((part1, part2) -> part1.getName().compareTo(part2.getName()));
        partUsages.removeIf(p -> STATE_MACHINE_MODEL.getFirstNominalStateMachine(p) == null);
        try {
            system = ModelUtil.getSystemPart((ResourceSet)EcoreUtil2.getResourceSet((Notifier)rootElement));
        }
        catch (Exception e) {
            DialogUtil.getInstance().showMessage_ExceptionError(e);
            return null;
        }
        partUsages.add(0, system);
        PartUsage selectedPart = AdapterUtil.getSelectedPart(activeShell, partUsages);
        if (selectedPart == null) {
            return null;
        }
        return new Pair((Object)selectedPart, (Object)AdapterUtil.generateSMV(selectedPart, timeSpecification));
    }

    public static PartUsage getSelectedPart(Shell activeShell, List<PartUsage> parts) {
        if (parts.size() == 1) {
            return parts.get(0);
        }
        if (parts.size() > 1) {
            ElementSelectorDialog dialog = new ElementSelectorDialog(activeShell, "Component Selector", "Select a component instance:");
            dialog.addElements(parts);
            if (dialog.open() == 0) {
                return (PartUsage)dialog.getSelection();
            }
        }
        return null;
    }

    public static GeneratedFiles prepareExpandedFiles(PartUsage systemComponent, String smvFileName) throws Exception {
        String fileName = SYSTEM_MODEL.getName((Object)ModelUtil.getModel((EObject)systemComponent));
        String systemName = SYSTEM_MODEL.getName((Object)systemComponent);
        String modelName = fileName + "_" + systemName;
        String feiFileName = AdapterUtil.computeFeiFileName(modelName);
        String expandedFeiFileName = AdapterUtil.computeExpandedFeiFileName(modelName);
        String extendedSmvFileName = AdapterUtil.computeExtendedSmvFileName(modelName);
        String fmsFileName = AdapterUtil.computeFmsFileName(modelName);
        String ftFileName = AdapterUtil.computeFtFileName(modelName);
        GeneratedFiles files = new GeneratedFiles(modelName, feiFileName, expandedFeiFileName, extendedSmvFileName, fmsFileName, ftFileName);
        FeiTranslatorServiceAPI.getInstance((AbstractSystemModel)SYSTEM_MODEL, (AbstractStateMachineModel)STATE_MACHINE_MODEL).exportFaultyStateMachinesToFeiFile((Object)ModelUtil.getModel((EObject)systemComponent), NuXmvDirectoryUtil.getInstance().getSmvFileDirectory(), modelName, null, (IProgressMonitor)new NullProgressMonitor());
        if (!XSapExecService.getInstance().expandFaultExtensions(feiFileName, expandedFeiFileName, true)) {
            return null;
        }
        if (!XSapExecService.getInstance().extendModel(smvFileName, expandedFeiFileName, fmsFileName, extendedSmvFileName, true)) {
            return null;
        }
        return files;
    }

    private static String computeFmsFileName(String modelName) throws Exception {
        return NuXmvDirectoryUtil.getInstance().getSmvTempDirectory() + File.separator + "fms_" + modelName + XML_EXT;
    }

    private static String computeExtendedSmvFileName(String modelName) throws Exception {
        return NuXmvDirectoryUtil.getInstance().getSmvTempDirectory() + File.separator + "extended_" + modelName + SMV_EXT;
    }

    private static String computeExpandedFeiFileName(String modelName) throws Exception {
        return NuXmvDirectoryUtil.getInstance().getSmvTempDirectory() + File.separator + "expanded_" + modelName + XML_EXT;
    }

    private static String computeFeiFileName(String modelName) throws Exception {
        return NuXmvDirectoryUtil.getInstance().getSmvFileDirectory() + File.separator + modelName + FEI_EXT;
    }

    private static String computeFtFileName(String modelName) throws Exception {
        return AdapterUtil.getResultDir() + File.separator + "extended_" + modelName + "_" + AdapterUtil.getDate() + XML_EXT;
    }

    private static String getDate() {
        String pattern = "yyyy-MM-dd-HH-mm-ss";
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(pattern);
        return simpleDateFormat.format(new Date());
    }

    private static String getResultDir() throws Exception {
        String resultDir = DirectoryUtil.getInstance().getCurrentProjectDir() + RESULTS_FILE_PATH;
        File directory = new File(resultDir);
        if (!directory.exists()) {
            return AdapterUtil.createResultDir(resultDir);
        }
        return resultDir;
    }

    private static String createResultDir(String dirName) {
        block3: {
            try {
                File directory = new File(dirName);
                if (directory.mkdirs()) break block3;
                ErrorsDialogUtil.getInstance().showMessage_GenericError("Cannot create results directory: " + dirName);
                return null;
            }
            catch (Exception e) {
                DialogUtil.getInstance().showMessage_ExceptionError(e);
                e.printStackTrace();
                return null;
            }
        }
        return dirName;
    }

    public record GeneratedFiles(String modelName, String feiFileName, String expandedFeiFileName, String extendedSmvFileName, String fmsFileName, String ftFileName) {
    }
}

