<#ftl encoding='UTF-8'>
<#global indent = "    ">
<#global indent2 = "        ">
<#global indent3 = "            ">
<#global indent4 = "                ">
<#global indent5 = "                    ">
<#global indentMacro = "                         ">
from enum import IntEnum

class ${name}():

${indent}def __init__(self):
${indent2}self.curr_init_transition = self.InitTransition.T_Undef
${indent2}self.curr_transition = self.Transition.T_Undef

${indent}class State(IntEnum):
${indent2}S_Undef = 0
<#list 0..stateMachine.states?size-1 as i>${indent2}${stateMachine.states[i].name} = ${i+1}
</#list> 

<#if (stateMachine??)>
${indent}# enumerative class used by the current init transition variable
${indent}# T_Undef is the value used when the current init transition variable is initialized
${indent}# the other value is the name of the init transition of the state machine
${indent}class InitTransition(IntEnum):
${indent2}T_Undef = 0
<#list 0..stateMachine.initTransitions?size-1 as i>${indent2}${stateMachine.initTransitions[i].name} = ${i+1}
</#list> 

${indent}# enumerative class used by the current transition variable
${indent}# T_Undef is the value used when the current transition variable is initialized
${indent}# the other values are the names of the transitions of the state machine
${indent}class Transition(IntEnum):
${indent2}T_Undef = 0
<#list 0..stateMachine.transitions?size-1 as i>${indent2}${stateMachine.transitions[i].name} = ${i+1}
</#list>  
</#if>



<#list enums as enumType>${indent}class ${enumType.name}(IntEnum):
<#list 0..enumType.values?size-1 as i>${indent2}${enumType.values[i]} = ${i}
</#list>
</#list>

${indent}def is_current_state(self, stateval):
${indent2}return self.get_fsmState() == stateval

${indent}def set_fsmState(self, stateval):
${indent2}self.state = stateval

${indent}def get_fsmState(self):
${indent2}return self.state

${indent}def init(self):
<#list 0..stateMachine.initTransitions?size-1 as i>${indent2}<#if i == 0>if</#if><#if i != 0>elif</#if>(self.guard_${stateMachine.initTransitions[i].name}()):
${indent3}self.curr_init_transition = self.InitTransition.${stateMachine.initTransitions[i].name}
        </#list>
${indent2}else:
${indent3}# if the current init transition is not set, an exception will be raised
${indent3}print("the current init transition is not set")

${indent2}# check what is the current initial transition
${indent2}# to set the current state and to execute the effects of the current initial transition
${indent2}if self.curr_init_transition == self.InitTransition.T_Undef:
${indent3}# if the current init transition variable is not set, an exception will be raised
${indent3} print("the current init transition is not set")
<#list 0..stateMachine.initTransitions?size-1 as i>${indent2}elif self.curr_init_transition == self.InitTransition.${stateMachine.initTransitions[i].name}:
${indent3}self.set_fsmState(self.State.${stateMachine.initTransitions[i].outState})
${indent3}self.effect_${stateMachine.initTransitions[i].name?replace("\n", "\n"+indent3)}()
${indent3}
</#list>   



${indent}def execute(self):

${indent2}self.curr_transition = self.Transition.T_Undef
<#list 0..stateMachine.states?size-1 as i>${indent2}<#if i == 0>if</#if><#if i != 0>elif</#if> self.is_current_state(self.State.${stateMachine.states[i].name}):
<#if (stateMachine.states[i].outTransitions?size>0) ><#list 0..stateMachine.states[i].outTransitions?size-1 as j><#--
-->${indent3}<#if j == 0>if</#if><#if j != 0>elif</#if><#--
-->(self.guard_${stateMachine.states[i].outTransitions[j].name}()):
${indent4}self.curr_transition = self.Transition.${stateMachine.states[i].outTransitions[j].name}
</#list><#else>${indent3}self.curr_transition = self.Transition.T_Undef
</#if>
</#list>
${indent2}else:
${indent3}# if the current state variable is not set, an exception will be raised
${indent3}print("the current state variable is not set")

${indent2}if self.curr_transition == self.Transition.T_Undef:
${indent3}# if the current transition variable is not set, an exception will be raised
${indent3}print("the current transition variable is not set")
<#list 0..stateMachine.transitions?size-1 as i>${indent2}elif self.curr_transition == self.Transition.${stateMachine.transitions[i].name}:
${indent3}self.set_fsmState(self.State.${stateMachine.transitions[i].outState})
<#if stateMachine.transitions[i].name!="">${indent3}self.effect_${stateMachine.transitions[i].name?replace("\n", "\n"+indent3)}()
</#if>
</#list>            

${indent}def set_input(self <#list inputPorts as parameter>, ${parameter.name}</#list>):
<#list inputPorts as parameter>${indent2}self.${parameter.name} = ${parameter.name}
</#list>

${indent}# setters for inputPorts
<#list inputPorts as parameter>
${indent}def set_${parameter.name}(self, value):
<@printSetter currIndent=indent2 varName=parameter.name/>

</#list>

${indent}# getters for inputPorts
<#list inputPorts as parameter>
${indent}def get_${parameter.name}(self):
<@printGetter currIndent=indent2 varName=parameter.name/>

</#list>

${indent}# setters for outputPorts
<#list outputPorts as parameter>
${indent}def set_${parameter.name}(self, value):
<@printSetter currIndent=indent2 varName=parameter.name/>

</#list>

${indent}# getters for outputPorts
<#list outputPorts as parameter>
${indent}def get_${parameter.name}(self):
<@printGetter currIndent=indent2 varName=parameter.name/>

</#list>

${indent}# setters for attributes
<#list attributes as parameter>
${indent}def set_${parameter.name}(self, value):
<@printSetter currIndent=indent2 varName=parameter.name/>

</#list>

${indent}# getters for attributes
<#list attributes as parameter>
${indent}def get_${parameter.name}(self):
<@printGetter currIndent=indent2 varName=parameter.name/>

</#list>

<#list stateMachine.initTransitions as transition>
${indent}def guard_${transition.name}(self):
${indent2}${transition.guardBody?replace("\n", "\n"+indent2)}
	
</#list>
<#list stateMachine.transitions as transition>
${indent}def guard_${transition.name}(self):
${indent2}${transition.guardBody?replace("\n", "\n"+indent2)}
	
</#list>

<#list stateMachine.initTransitions as transition>
${indent}def effect_${transition.name}(self):
${indent2}${transition.effectBody?replace("\n", "\n"+indent2)}
	
</#list>
<#list stateMachine.transitions as transition>
${indent}def effect_${transition.name}(self):
${indent2}${transition.effectBody?replace("\n", "\n"+indent2)}

</#list>

<#macro printGetter currIndent varName>
${currIndent}return self.${varName}
</#macro>
<#macro printSetter currIndent varName>
${currIndent}self.${varName} = value
</#macro>
