/*
 * SPDX-FileCopyrightText: 2025 Fondazione Bruno Kessler
 *
 * SPDX-FileContributor: Luca Cristoforetti - initial API and implementation
 */
package eu.fbk.eclipse.explodtwin.ossimporter.core;

import org.eclipse.emf.ecore.EObject;
import eu.fbk.tools.editor.oss.oss.*;
import eu.fbk.eclipse.standardtools.utils.core.visitors.ITreeGenericVisitorAction;
import eu.fbk.tools.editor.basetype.baseType.*;
import eu.fbk.tools.editor.contract.contract.*;
import eu.fbk.tools.editor.contract.expression.expression.*;

public interface IOssVisitorAction extends ITreeGenericVisitorAction {

	public abstract void action(Assumption o) throws Exception;

	public abstract void action(Guarantee o) throws Exception;

	public abstract void action(TimeAnnotation o) throws Exception;
	
	public abstract void action(RealType o) throws Exception;
	
	public abstract void action(IntegerType o) throws Exception;
	
	public abstract void action(ComplexType o) throws Exception;
	
	public abstract void action(ContinuousType o) throws Exception;
	
	public abstract void action(InputPort o) throws Exception;
	
	public abstract void action(InterfaceInstance o) throws Exception;
	
	public abstract void action(BooleanType o) throws Exception;
	
	public abstract void action(OutputPort o) throws Exception;
	
	public abstract void action(PortId o) throws Exception;
	
	public abstract void action(Identifier o) throws Exception;
	
	public abstract void action(BooleanLiteral o) throws Exception;
	
	public abstract void action(EnumType o) throws Exception;
	
	public abstract void action(FullPortId o) throws Exception;
	
	public abstract void action(EqualityOperator o) throws Exception;
	
	public abstract void action(IntegerLiteral o) throws Exception;
	
	public abstract void action(EqualityExpression o) throws Exception;
	
	public abstract void action(BoundedExpression o) throws Exception;
	
	public abstract void action(LogicalAndOperator o) throws Exception;
	
	public abstract void action(LogicalOrOperator o) throws Exception;
	
	public abstract void action(LogicalExpression o) throws Exception;
	
	public abstract void action(Operator o) throws Exception;
	
	public abstract void action(NextFunction o) throws Exception;
	
	public abstract void action(ExtendedLogicalOperator o) throws Exception;
	
	public abstract void action(UnaryTemporalExpression o) throws Exception;
	
	public abstract void action(UnaryLogicalOperator o) throws Exception;
	
	public abstract void action(Contract o) throws Exception;
	
	public abstract void action(ChangeFunction o) throws Exception;
	
	public abstract void action(FallRiseFunction o) throws Exception;
	
	public abstract void action(TimeSinceUntilFunction o) throws Exception;
	
	public abstract void action(UnaryLogicalExpression o) throws Exception;
	
	public abstract void action(Interface o) throws Exception;
	
	public abstract void action(SystemComponent o) throws Exception;
	
	public abstract void action(OSS o) throws Exception;
	
	public abstract void action(ComponentId o) throws Exception;
	
	public abstract void action(SubComponentType o) throws Exception;
	
	public abstract void action(SubComponent o) throws Exception;
	
	public abstract void action(RefinementInstance o) throws Exception;
	
	public abstract void action(IterativeCondition o) throws Exception;
	
	public abstract void action(Connection o) throws Exception;
	
	public abstract void action(AddSubExpression o) throws Exception;
	
	public abstract void action(RelationalExpression o) throws Exception;
	
	public abstract void action(UnaryAlgebraicExpression o) throws Exception;
	
	public abstract void action(Component o) throws Exception;
	
	public abstract void action(Refinement o) throws Exception;
	
	public abstract void action(RangeType o) throws Exception;
	
	public abstract void action(FullContractIdList o) throws Exception;
	
	public abstract void action(RefinedBy o) throws Exception;
	
	public abstract void action(CountFunction o) throws Exception;
	
	public abstract void action(DerivativeFunction o) throws Exception;
	
	public abstract void action(ClockType o) throws Exception;
	
	public abstract void action(Parameter o) throws Exception;
	
	public abstract void action(ParameterId o) throws Exception;
	
	public abstract void action(Define o) throws Exception;
	
	public abstract void action(Assertion o) throws Exception;
	
	public abstract void action(RealLiteral o) throws Exception;
	
	public abstract void action(EventType o) throws Exception;
	
	public abstract void action(InvarBehaviour o) throws Exception;
	
	public abstract void action(TemporalExpression o) throws Exception;
	
	public abstract void action(Bound o) throws Exception;
	
	default void genericAction(final EObject o) throws Exception {
		if (o instanceof Assumption) {
			action((Assumption) o);
		} else if (o instanceof Guarantee) {
			action((Guarantee) o);
		} else if (o instanceof Bound) {
			action((Bound) o);
		} else if (o instanceof TimeAnnotation) {
			action((TimeAnnotation) o);
		} else if (o instanceof PortId) {
			action((PortId) o);
		} else if (o instanceof RealType) {
			action((RealType) o);
		} else if (o instanceof IntegerType) {
			action((IntegerType) o);
		} else if (o instanceof ComplexType) {
			action((ComplexType) o);
		} else if (o instanceof InputPort) {
			action((InputPort) o);
		} else if (o instanceof ContinuousType) {
			action((ContinuousType) o);
		} else if (o instanceof InterfaceInstance) {
			action((InterfaceInstance) o);
		} else if (o instanceof BooleanType) {
			action((BooleanType) o);
		} else if (o instanceof OutputPort) {
			action((OutputPort) o);
		} else if (o instanceof Identifier) {
			action((Identifier) o);
		} else if (o instanceof EnumType) {
			action((EnumType) o);
		} else if (o instanceof BooleanLiteral) {
			action((BooleanLiteral) o);
		} else if (o instanceof FullPortId) {
			action((FullPortId) o);
		} else if (o instanceof EqualityOperator) {
			action((EqualityOperator) o);
		} else if (o instanceof IntegerLiteral) {
			action((IntegerLiteral) o);
		} else if (o instanceof EqualityExpression) {
			action((EqualityExpression) o);
		} else if (o instanceof BoundedExpression) {
			action((BoundedExpression) o);
		} else if (o instanceof LogicalAndOperator) {
			action((LogicalAndOperator) o);
		} else if (o instanceof LogicalOrOperator) {
			action((LogicalOrOperator) o);
		} else if (o instanceof LogicalExpression) {
			action((LogicalExpression) o);
		} else if (o instanceof NextFunction) {
			action((NextFunction) o);
		} else if (o instanceof ExtendedLogicalOperator) {
			action((ExtendedLogicalOperator) o);
		} else if (o instanceof UnaryTemporalExpression) {
			action((UnaryTemporalExpression) o);
		} else if (o instanceof UnaryLogicalOperator) {
			action((UnaryLogicalOperator) o);
		} else if (o instanceof Contract) {
			action((Contract) o);
		} else if (o instanceof ChangeFunction) {
			action((ChangeFunction) o);
		} else if (o instanceof FallRiseFunction) {
			action((FallRiseFunction) o);
		} else if (o instanceof TimeSinceUntilFunction) {
			action((TimeSinceUntilFunction) o);
		} else if (o instanceof UnaryLogicalExpression) {
			action((UnaryLogicalExpression) o);
		} else if (o instanceof Interface) {
			action((Interface) o);
		} else if (o instanceof SystemComponent) {
			action((SystemComponent) o);
		} else if (o instanceof OSS) {
			action((OSS) o);
		} else if (o instanceof ComponentId) {
			action((ComponentId) o);
		} else if (o instanceof SubComponentType) {
			action((SubComponentType) o);
		} else if (o instanceof SubComponent) {
			action((SubComponent) o);
		} else if (o instanceof RefinementInstance) {
			action((RefinementInstance) o);
		} else if (o instanceof IterativeCondition) {
			action((IterativeCondition) o);
		} else if (o instanceof Connection) {
			action((Connection) o);
		} else if (o instanceof AddSubExpression) {
			action((AddSubExpression) o);
		} else if (o instanceof RelationalExpression) {
			action((RelationalExpression) o);
		} else if (o instanceof UnaryAlgebraicExpression) {
			action((UnaryAlgebraicExpression) o);
		} else if (o instanceof Component) {
			action((Component) o);
		} else if (o instanceof Refinement) {
			action((Refinement) o);
		} else if (o instanceof RangeType) {
			action((RangeType) o);
		} else if (o instanceof CountFunction) {
			action((CountFunction) o);
		} else if (o instanceof DerivativeFunction) {
			action((DerivativeFunction) o);
		} else if (o instanceof FullContractIdList) {
			action((FullContractIdList) o);
		} else if (o instanceof RefinedBy) {
			action((RefinedBy) o);
		} else if (o instanceof ClockType) {
			action((ClockType) o);
		} else if (o instanceof Parameter) {
			action((Parameter) o);
		} else if (o instanceof ParameterId) {
			action((ParameterId) o);
		} else if (o instanceof Assertion) {
			action((Assertion) o);
		} else if (o instanceof Define) {
			action((Define) o);
		} else if (o instanceof EventType) {
			action((EventType) o);
		} else if (o instanceof RealLiteral) {
			action((RealLiteral) o);
		} else if (o instanceof InvarBehaviour) {
			action((InvarBehaviour) o);
		} else if (o instanceof TemporalExpression) {
			action((TemporalExpression) o);
		} else if (o instanceof Operator) {
			action((Operator) o);
		} else {
			throw new Exception("Unsupported Object: " + o.toString());
		}
	}

}
