/*
 * SPDX-FileCopyrightText: 2025 Fondazione Bruno Kessler
 *
 * SPDX-FileContributor: Luca Cristoforetti - initial API and implementation
 */
package eu.fbk.eclipse.explodtwin.ossimporter.ui.commands;

import java.io.File;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import eu.fbk.eclipse.standardtools.utils.ui.utils.DialogUtil;
import eu.fbk.eclipse.standardtools.utils.ui.utils.OCRADialogUtil;
import eu.fbk.eclipse.explodtwin.ossimporter.core.OssModelImporter;

/**
 * Converts a OSS input file into a SysML v2 model.
 *
 */
public class ImportOssFileCommand extends AbstractHandler {
	private OCRADialogUtil ocraDialogUtil = OCRADialogUtil.getInstance();
	private DialogUtil dialogUtil = DialogUtil.getInstance();
	private OssModelImporter ossModelImporter = new OssModelImporter();

	@Override
	public Object execute(ExecutionEvent event) throws ExecutionException {
		try {
			
			// Get a OSS file from the user selection
			File ossFile = ocraDialogUtil.getOssFileFromFileDialog();
			if (ossFile != null) {
				File sysMLFile = ossModelImporter.processModel(ossFile, null);
				String message = "SysML file is stored as: " + sysMLFile.getAbsolutePath();
				dialogUtil.showMessage_GenericMessage("SysMLv2 Generation", message);
			}
		} catch (Exception e) {
			dialogUtil.showMessage_ExceptionError(e);
			e.printStackTrace();
		}
		return null;
	}
}