/*
 * SPDX-FileCopyrightText: 2025 Fondazione Bruno Kessler
 *
 * SPDX-FileContributor: Luca Cristoforetti - initial API and implementation
 */
package eu.fbk.eclipse.explodtwin.ossimporter.utils;

import java.util.List;

import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.EcoreUtil2;

import eu.fbk.tools.editor.basetype.baseType.EnumType;
import eu.fbk.tools.editor.basetype.baseType.Expression;
import eu.fbk.tools.editor.contract.expression.expression.FullPortId;
import eu.fbk.tools.editor.contract.expression.expression.FullVariableId;
import eu.fbk.tools.editor.oss.oss.AbstractComponent;
import eu.fbk.tools.editor.oss.oss.InputPort;
import eu.fbk.tools.editor.oss.oss.OutputPort;
import eu.fbk.tools.editor.oss.oss.SubComponent;

/**
 * This class contains some utilies to query an OSS model.
 */
public class OssModelUtil {

	/**
	 * Returns the name of the Component owning the given item.
	 * @param item
	 * @return
	 */
	public static String getOwnerComponentName(EObject item) {
		return eu.fbk.tools.editor.oss.validation.ModelUtil.getParentComponentType(item).getType();
	}

	/**
	 * Given a subcomp name, returns its type, browsing its component.
	 * @param expr an Expression used to retrieve the containing component
	 * @param subCompName the name of the subcomponent
	 * @return
	 */
	//FIXME: This method is not fully working, it works only for one level of hierarchy,
	// but it should navigate the whole hierarchy, i.e., a.b.subcomp
	public static String getSubComponentType(Expression expr, String subCompName) {
		final AbstractComponent component = eu.fbk.tools.editor.oss.validation.ModelUtil.getParentComponentType(expr);
		final List<SubComponent> subComps = eu.fbk.tools.editor.oss.validation.ModelUtil.getSubComponents(component);
		if (subComps != null && !subComps.isEmpty() ) {
			for (SubComponent subComp : subComps) {
				if (subComp.getName().getName().equals(subCompName)) {
					return subComp.getType().getComponentTypeName();
				}
			}
		}
		return null;
	}
	
	/**
	 * Returns the name of the port associated to this enum, if any.
	 * @param enumType
	 * @return
	 */
	public static String getPortNameForEnum(EnumType enumType) {
		final InputPort in = EcoreUtil2.getContainerOfType(enumType, InputPort.class);
		if (in != null) {
			return in.getId().getName();
		} else {
			final OutputPort out = EcoreUtil2.getContainerOfType(enumType, OutputPort.class);
			if (out != null) {
				return out.getId().getName();
			}
		}
		return null;
	}

	/**
	 * Checks if the given expression is a value that could be assigned to a variable.
	 * @param expr
	 * @return
	 */
	public static boolean isValue(String expr) {
		if (expr.contains("\"")) { 
			return true;
		} else if (NumberUtils.isNumber(expr)) { 
			return true;
		} else if (BooleanUtils.toBooleanObject(expr) != null) {
			return true;
		} else {
			return false;
		}
	}

	/**
	 * Returns true if the given expression is a simple port.
	 * @param expression
	 * @return
	 */
	public static boolean isSimplePortId(Expression expression) {
		return (expression instanceof FullPortId) ? ((FullVariableId) expression).getFullComponentIds().isEmpty() : false;
	}
	
}
