/*
 * SPDX-FileCopyrightText: 2024 Fondazione Bruno Kessler
 *
 * SPDX-FileContributor: Tommaso Fonda - initial API and implementation
 */
package eu.fbk.eclipse.explodtwin;

import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;

public class Activator implements BundleActivator {

	/** The plug-in ID. */
	public static final String PLUGIN_ID = Activator.class.getPackage().getName();

	/** The shared instance. */
	private static Activator plugin;

	/** {@inheritDoc} */
	@Override
	public void start(BundleContext context) throws Exception
	{
		plugin = this;
	}

	/** {@inheritDoc} */
	@Override
	public void stop(BundleContext context) throws Exception
	{
		plugin = null;
	}

	/** Returns the shared instance. */
	public static Activator getDefault()
	{
		return plugin;
	}

}