/*
 * SPDX-FileCopyrightText: 2024 Fondazione Bruno Kessler
 *
 * SPDX-FileContributor: Luca Cristoforetti - initial API and implementation
 */
package eu.fbk.eclipse.explodtwin.ui;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;
import org.eclipse.xtext.EcoreUtil2;

import eu.fbk.eclipse.explodtwin.api.util.ModelUtil;
import eu.fbk.eclipse.explodtwin.util.AdapterUtil;
import eu.fbk.sysmlv2.SysMLv2Activator;
import eu.fbk.sysmlv2.sysMLv2.PartUsage;

/**
 * WARNING: This class is no more working due to changes in the code.
 * This class controls all aspects of the application's execution.
 */
public class ExploDTwin implements IApplication {

	private static final String FILE_NAME = "in.sysml";
	private static final String PROJECT_NAME = "TestProject";

	@Override
	public Object start(IApplicationContext context) throws Exception {
		eu.fbk.sysmlv2.SysMLv2StandaloneSetup.doSetup();
		System.out.println("ExploDTwin application!");

		IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(PROJECT_NAME);
		if (!project.exists()) {
			project.create(new NullProgressMonitor());
		}
		project.open(null);

		// Create the path to the new IFile
        IPath filePath = new Path(FILE_NAME);
        IFile iFile = project.getFile(filePath);

		Resource resource = AdapterUtil.getResource(iFile);
		SysMLv2Activator.populateResourceSet(resource.getResourceSet());

		if (resource.getContents().size() != 1) {
			System.out.println("Resource not has a root element");
			return IApplication.EXIT_OK;
		}

		final EObject top = resource.getContents().get(0);
		final PartUsage systemComponent = ModelUtil.getSystemPart(EcoreUtil2.getResourceSet(top));
		System.out.println("root = " + systemComponent);

		final int timeSpecification = 1;

		// Export to OSS-OCRA
		AdapterUtil.generateOCRA(systemComponent, timeSpecification);

		// This is needed for the SMV generation
//		AdapterUtil.setOcraPath();

		// Export to SVM
		AdapterUtil.generateSMV(systemComponent, timeSpecification);

		/*
		// Example of tree visitor
		SysMLv2VisitorAction visitorAction = new SysMLv2VisitorAction();

		System.out.println("Approccio bottom-up");
		TreeVisitor visitor = new TreeVisitor(visitorAction, Order.POSTORDER);
		visitor.run(top);

		System.out.println("Approccio top-down");
		visitor = new TreeVisitor(visitorAction, Order.PREORDER);
		visitor.run(top);

		*/

		ResourcesPlugin.getWorkspace().save(true, null);

		return IApplication.EXIT_OK;
	}

	@Override
	public void stop() {
	}
}
