package eu.fbk.eclipse.explodtwin.ui.commands;

import java.io.IOException;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.resource.XtextResourceSet;

import eu.fbk.eclipse.explodtwin.api.util.PostProcessor;
import eu.fbk.tools.adapter.ui.commands.AbstractToolCommand;

public abstract class AbstractBaseToolCommand extends AbstractToolCommand {

	public AbstractBaseToolCommand(String toolName, String commandDescription, String keyToolExecutable,
			String keyToolTimeout) {
		super(toolName, commandDescription, keyToolExecutable, keyToolTimeout);
	}

	protected ResourceSet createWorkingCopy(ResourceSet resourceSet) {
		final ResourceSet newResourceSet = new XtextResourceSet();
		resourceSet.getResources().forEach(originalResource -> {
			final EObject rootEObject = originalResource.getContents().get(0);
			final String originalResourceText = NodeModelUtils.getNode(rootEObject).getText();
			final XtextResource newResource = (XtextResource) newResourceSet.createResource(originalResource.getURI());
			try {
				newResource.reparse(originalResourceText);
			} catch (IOException e) {
				throw new RuntimeException(e);
			}
		});
		final boolean isExplodtwin = resourceSet.getResources().stream()
				.map(Resource::getURI)
				.anyMatch(uri -> uri.toString().contains("explodtwin"));
		new PostProcessor(newResourceSet, isExplodtwin).performPostProcessing();
		return newResourceSet;
	}

}
