/*
 * SPDX-FileCopyrightText: 2024 Fondazione Bruno Kessler
 *
 * SPDX-FileContributor: Tommaso Fonda - initial API and implementation
 */
package eu.fbk.sysmlv2.ide;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xtext.ide.editor.syntaxcoloring.DefaultSemanticHighlightingCalculator;
import org.eclipse.xtext.ide.editor.syntaxcoloring.HighlightingStyles;
import org.eclipse.xtext.ide.editor.syntaxcoloring.IHighlightedPositionAcceptor;
import org.eclipse.xtext.util.CancelIndicator;

import eu.fbk.sysmlv2.sysMLv2.NamedElement;
import eu.fbk.sysmlv2.sysMLv2.QualifiedNameExpression;
import eu.fbk.sysmlv2.sysMLv2.ReferenceExpression;
import eu.fbk.sysmlv2.sysMLv2.UsageChainExpression;

public class SysMLv2SemanticHighlightingCalculator extends DefaultSemanticHighlightingCalculator {

	@Override
	protected boolean highlightElement(EObject object, IHighlightedPositionAcceptor acceptor,
			CancelIndicator cancelIndicator) {
		if (object instanceof final NamedElement namedElement && "payload".equals(namedElement.getName())) {
			highlightFeature(acceptor, object, namedElement.eClass().getEStructuralFeature("name"), HighlightingStyles.DEFAULT_ID);
			return true;
		} else if (object instanceof final ReferenceExpression referenceExpression) {
			final NamedElement referencedElement = referenceExpression.getReferencedElement();
			if (referencedElement == null) {
				return false;
			} else if ("payload".equals(referencedElement.getName())) {
				EStructuralFeature featureToHighlight;
				if (referenceExpression instanceof final QualifiedNameExpression qualifiedNameExpression) {
					featureToHighlight = qualifiedNameExpression.eClass().getEStructuralFeature("referencedElement");
				} else if (referenceExpression instanceof final UsageChainExpression usageChainExpression) {
					featureToHighlight = usageChainExpression.eClass().getEStructuralFeature("tail");
				} else {
					throw new IllegalArgumentException("Ill-formed ReferenceExpression.");
				}
				highlightFeature(acceptor, object, featureToHighlight, HighlightingStyles.DEFAULT_ID);
				return true;
			}
		}
		return false;
	}

}
