/*
 * SPDX-FileCopyrightText: 2024 Fondazione Bruno Kessler
 *
 * SPDX-FileContributor: Tommaso Fonda - initial API and implementation
 */
/*
 * generated by Xtext 2.34.0
 */
package eu.fbk.sysmlv2.ui.contentassist;

import java.util.stream.Collectors;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.xtext.Assignment;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.Group;
import org.eclipse.xtext.Keyword;
import org.eclipse.xtext.RuleCall;
import org.eclipse.xtext.ui.editor.contentassist.ConfigurableCompletionProposal;
import org.eclipse.xtext.ui.editor.contentassist.ContentAssistContext;
import org.eclipse.xtext.ui.editor.contentassist.ICompletionProposalAcceptor;
import org.eclipse.xtext.ui.editor.contentassist.ICompletionProposalAcceptor.Delegate;

import com.google.inject.Inject;

import eu.fbk.sysmlv2.services.SysMLv2GrammarAccess;

/**
 * See https://www.eclipse.org/Xtext/documentation/310_eclipse_support.html#content-assist
 * on how to customize the content assistant.
 */
public class SysMLv2ProposalProvider extends AbstractSysMLv2ProposalProvider {

	@Inject
	private SysMLv2GrammarAccess grammarAccess;

	@Override
	public void complete_AboutKeyword(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
		acceptor.accept(createCompletionProposal(grammarAccess.getAboutKeywordAccess().getAboutKeyword().getValue(), context));
	}

	@Override
	public void complete_AbstractKeyword(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
		acceptor.accept(createCompletionProposal(grammarAccess.getAbstractKeywordAccess().getAbstractKeyword().getValue(), context));
	}

	@Override
	public void complete_AcceptKeyword(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
		acceptor.accept(createCompletionProposal(grammarAccess.getAcceptKeywordAccess().getAcceptKeyword().getValue(), context));
	}

	@Override
	public void complete_ActionKeyword(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
		acceptor.accept(createCompletionProposal(grammarAccess.getActionKeywordAccess().getActionKeyword().getValue(), context));
	}

	@Override
	public void complete_AfterKeyword(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
		acceptor.accept(createCompletionProposal(grammarAccess.getAfterKeywordAccess().getAfterKeyword().getValue(), context));
	}

	@Override
	public void complete_AssertKeyword(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
		acceptor.accept(createCompletionProposal(grammarAccess.getAssertKeywordAccess().getAssertKeyword().getValue(), context));
	}

	@Override
	public void complete_AssignKeyword(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
		acceptor.accept(createCompletionProposal(grammarAccess.getAssignKeywordAccess().getAssignKeyword().getValue(), context));
	}

	@Override
	public void complete_AttributeKeyword(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
		acceptor.accept(createCompletionProposal(grammarAccess.getAttributeKeywordAccess().getAttributeKeyword().getValue(), context));
	}

	@Override
	public void complete_BindKeyword(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
		acceptor.accept(createCompletionProposal(grammarAccess.getBindKeywordAccess().getBindKeyword().getValue(), context));
	}

	@Override
	public void complete_CalculationKeyword(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
		acceptor.accept(createCompletionProposal(grammarAccess.getCalculationKeywordAccess().getCalcKeyword().getValue(), context));
	}

	@Override
	public void complete_CommentKeyword(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
		acceptor.accept(createCompletionProposal(grammarAccess.getCommentKeywordAccess().getCommentKeyword().getValue(), context));
	}

	@Override
	public void complete_ConnectKeyword(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
		acceptor.accept(createCompletionProposal(grammarAccess.getConnectKeywordAccess().getConnectKeyword().getValue(), context));
	}

	@Override
	public void complete_ConstraintKeyword(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
		acceptor.accept(createCompletionProposal(grammarAccess.getConstraintKeywordAccess().getConstraintKeyword().getValue(), context));
	}

	@Override
	public void complete_DefaultKeyword(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
		acceptor.accept(createCompletionProposal(grammarAccess.getDefaultKeywordAccess().getDefaultKeyword().getValue(), context));
	}

	@Override
	public void complete_DefinedByKeyword(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
		final Group group = grammarAccess.getDefinedByKeywordAccess().getGroup_1();
		final String proposal = EcoreUtil2.typeSelect(group.getElements(), Keyword.class).stream()
				.map(Keyword::getValue)
				.collect(Collectors.joining(" "));
		acceptor.accept(createCompletionProposal(proposal, context));
	}

	@Override
	public void complete_DefinitionKeyword(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
		acceptor.accept(createCompletionProposal(grammarAccess.getDefinitionKeywordAccess().getDefKeyword().getValue(), context));
	}

	@Override
	public void complete_DoKeyword(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
		acceptor.accept(createCompletionProposal(grammarAccess.getDoKeywordAccess().getDoKeyword().getValue(), context));
	}

	@Override
	public void complete_DocumentationKeyword(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
		acceptor.accept(createCompletionProposal(grammarAccess.getDocumentationKeywordAccess().getDocKeyword().getValue(), context));
	}

	@Override
	public void complete_DoneKeyword(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
		acceptor.accept(createCompletionProposal(grammarAccess.getDoneKeywordAccess().getDoneKeyword().getValue(), context));
	}

	@Override
	public void complete_EntryKeyword(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
		acceptor.accept(createCompletionProposal(grammarAccess.getEntryKeywordAccess().getEntryKeyword().getValue(), context));
	}

	@Override
	public void complete_EnumKeyword(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
		acceptor.accept(createCompletionProposal(grammarAccess.getEnumKeywordAccess().getEnumKeyword().getValue(), context));
	}

	@Override
	public void complete_FirstKeyword(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
		acceptor.accept(createCompletionProposal(grammarAccess.getFirstKeywordAccess().getFirstKeyword().getValue(), context));
	}

	@Override
	public void complete_IfKeyword(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
		acceptor.accept(createCompletionProposal(grammarAccess.getIfKeywordAccess().getIfKeyword().getValue(), context));
	}

	@Override
	public void complete_ImportKeyword(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
		acceptor.accept(createCompletionProposal(grammarAccess.getImportKeywordAccess().getImportKeyword().getValue(), context));
	}

	@Override
	public void complete_ItemKeyword(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
		acceptor.accept(createCompletionProposal(grammarAccess.getItemKeywordAccess().getItemKeyword().getValue(), context));
	}

	@Override
	public void complete_LibraryKeyword(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
		acceptor.accept(createCompletionProposal(grammarAccess.getLibraryKeywordAccess().getLibraryKeyword().getValue(), context));
	}

	@Override
	public void complete_LocaleKeyword(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
		acceptor.accept(createCompletionProposal(grammarAccess.getLocaleKeywordAccess().getLocaleKeyword().getValue(), context));
	}

	@Override
	public void complete_MetadataKeyword(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
		acceptor.accept(createCompletionProposal(grammarAccess.getMetadataKeywordAccess().getMetadataKeyword().getValue(), context));
	}

	@Override
	public void complete_NonuniqueKeyword(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
		acceptor.accept(createCompletionProposal(grammarAccess.getNonuniqueKeywordAccess().getNonuniqueKeyword().getValue(), context));
	}

	@Override
	public void complete_OrderedKeyword(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
		acceptor.accept(createCompletionProposal(grammarAccess.getOrderedKeywordAccess().getOrderedKeyword().getValue(), context));
	}

	@Override
	public void complete_PackageKeyword(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
		acceptor.accept(createCompletionProposal(grammarAccess.getPackageKeywordAccess().getPackageKeyword().getValue(), context));
	}

	@Override
	public void complete_PartKeyword(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
		acceptor.accept(createCompletionProposal(grammarAccess.getPartKeywordAccess().getPartKeyword().getValue(), context));
	}

	@Override
	public void complete_PayloadKeyword(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
		acceptor.accept(createCompletionProposal(grammarAccess.getPayloadKeywordAccess().getPayloadKeyword().getValue(), context));
	}

	@Override
	public void complete_PerformKeyword(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
		acceptor.accept(createCompletionProposal(grammarAccess.getPerformKeywordAccess().getPerformKeyword().getValue(), context));
	}

	@Override
	public void complete_PortKeyword(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
		acceptor.accept(createCompletionProposal(grammarAccess.getPortKeywordAccess().getPortKeyword().getValue(), context));
	}

	@Override
	public void complete_RedefinesKeyword(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
		acceptor.accept(createCompletionProposal(grammarAccess.getRedefinesKeywordAccess().getRedefinesKeyword_1().getValue(), context));
	}

	@Override
	public void complete_ReturnKeyword(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
		acceptor.accept(createCompletionProposal(grammarAccess.getReturnKeywordAccess().getReturnKeyword().getValue(), context));
	}

	@Override
	public void complete_SelfKeyword(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
		acceptor.accept(createCompletionProposal(grammarAccess.getSelfKeywordAccess().getSelfKeyword().getValue(), context));
	}

	@Override
	public void complete_SendKeyword(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
		acceptor.accept(createCompletionProposal(grammarAccess.getSendKeywordAccess().getSendKeyword().getValue(), context));
	}

	@Override
	public void complete_SpecializesKeyword(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
		acceptor.accept(createCompletionProposal(grammarAccess.getSpecializesKeywordAccess().getSpecializesKeyword_1().getValue(), context));
	}

	@Override
	public void complete_StartKeyword(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
		acceptor.accept(createCompletionProposal(grammarAccess.getStartKeywordAccess().getStartKeyword().getValue(), context));
	}

	@Override
	public void complete_StateKeyword(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
		acceptor.accept(createCompletionProposal(grammarAccess.getStateKeywordAccess().getStateKeyword().getValue(), context));
	}

	@Override
	public void complete_SubsetsKeyword(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
		acceptor.accept(createCompletionProposal(grammarAccess.getSubsetsKeywordAccess().getSubsetsKeyword_1().getValue(), context));
	}

	@Override
	public void complete_ThatKeyword(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
		acceptor.accept(createCompletionProposal(grammarAccess.getThatKeywordAccess().getThatKeyword().getValue(), context));
	}

	@Override
	public void complete_ThenKeyword(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
		acceptor.accept(createCompletionProposal(grammarAccess.getThenKeywordAccess().getThenKeyword().getValue(), context));
	}

	@Override
	public void complete_ToKeyword(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
		acceptor.accept(createCompletionProposal(grammarAccess.getToKeywordAccess().getToKeyword().getValue(), context));
	}

	@Override
	public void complete_TransitionKeyword(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
		acceptor.accept(createCompletionProposal(grammarAccess.getTransitionKeywordAccess().getTransitionKeyword().getValue(), context));
	}

	@Override
	public void complete_ViaKeyword(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
		acceptor.accept(createCompletionProposal(grammarAccess.getViaKeywordAccess().getViaKeyword().getValue(), context));
	}

	@Override
	public void complete_WhileKeyword(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
		acceptor.accept(createCompletionProposal(grammarAccess.getWhileKeywordAccess().getWhileKeyword().getValue(), context));
	}

	@Override
	public void completeReferenceForQNE_ReferencedElement(EObject model, Assignment assignment,
			ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
		super.completeReferenceForQNE_ReferencedElement(model, assignment, context, new StringProposalDelegate(acceptor, context));
	}

	@Override
	public void completeTailReferenceForUE_ReferencedElement(EObject model, Assignment assignment,
			ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
		super.completeTailReferenceForUE_ReferencedElement(model, assignment, context, new StringProposalDelegate(acceptor, context));
	}

	private static final class StringProposalDelegate extends Delegate {
		private final ContentAssistContext context;

		public StringProposalDelegate(ICompletionProposalAcceptor delegate, ContentAssistContext context) {
			super(delegate);
			this.context = context;
		}

		@Override
		public void accept(ICompletionProposal proposal) {
			if (proposal instanceof final ConfigurableCompletionProposal configurableProposal) {
				final int endPos = configurableProposal.getReplacementOffset() + configurableProposal.getReplacementLength();
				if (context.getDocument() != null && context.getDocument().getLength() > endPos) {
					// We are not at the end of the file
					try {
						if ("'".equals(context.getDocument().get(endPos, 1))) {
							configurableProposal.setReplacementLength(configurableProposal.getReplacementLength() - 1);
							final String currentString = configurableProposal.getReplacementString();
							configurableProposal.setReplacementString(currentString.substring(0, currentString.length() - 1));
						}
					} catch (BadLocationException e) {
						e.printStackTrace();
						return;
					}
				}
			}
			super.accept(proposal);
		}
	}

}
