/*
 * SPDX-FileCopyrightText: 2024 Fondazione Bruno Kessler
 *
 * SPDX-FileContributor: Tommaso Fonda - initial API and implementation
 */
package eu.fbk.sysmlv2.linking;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.diagnostics.Diagnostic;
import org.eclipse.xtext.diagnostics.DiagnosticMessage;
import org.eclipse.xtext.diagnostics.Severity;
import org.eclipse.xtext.linking.impl.LinkingDiagnosticMessageProvider;

import eu.fbk.sysmlv2.sysMLv2.Redefinition;

public class SysMLv2LinkingDiagnosticMessageProvider extends LinkingDiagnosticMessageProvider {
	@Override
	public DiagnosticMessage getUnresolvedProxyMessage(ILinkingDiagnosticContext linkingContext) {
		EObject context = linkingContext.getContext();

		/*
		 * Diagnostic message for invalid redefinitions.
		 */
		if (context instanceof Redefinition) {
			String msg = "Cannot reference an element not belonging to the parent "
					+ "Usage/Definition in a Redefinition.";
			return new DiagnosticMessage(msg, Severity.ERROR, Diagnostic.LINKING_DIAGNOSTIC);
		}
		return super.getUnresolvedProxyMessage(linkingContext);
	}
}