/*
 * SPDX-FileCopyrightText: 2024 Fondazione Bruno Kessler
 *
 * SPDX-FileContributor: Tommaso Fonda - initial API and implementation
 */
package eu.fbk.sysmlv2.naming;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.naming.DefaultDeclarativeQualifiedNameProvider;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.util.Strings;

import eu.fbk.sysmlv2.sysMLv2.impl.UsageImplCustom;

public class SysMLv2QualifiedNameProvider extends DefaultDeclarativeQualifiedNameProvider {

	@Override
	protected QualifiedName computeFullyQualifiedNameFromNameAttribute(EObject obj) {
		String name = getResolver().apply(obj);
		if (Strings.isEmpty(name) && obj instanceof final UsageImplCustom usage) {
			name = usage.getRedefinitionName();
		}
		if (Strings.isEmpty(name)) {
			return null;
		}
		QualifiedName qualifiedNameFromConverter = getConverter().toQualifiedName(name);
		while (obj.eContainer() != null) {
			obj = obj.eContainer();
			QualifiedName parentsQualifiedName = getFullyQualifiedName(obj);
			if (parentsQualifiedName != null) {
				return parentsQualifiedName.append(qualifiedNameFromConverter);
			}
		}
		return qualifiedNameFromConverter;
	}

}
