/*
 * SPDX-FileCopyrightText: 2024 Fondazione Bruno Kessler
 *
 * SPDX-FileContributor: Tommaso Fonda - initial API and implementation
 */
/*
 * generated by Xtext 2.34.0
 */
package eu.fbk.sysmlv2.scoping;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.naming.IQualifiedNameProvider;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.scoping.Scopes;
import org.eclipse.xtext.scoping.impl.FilteringScope;

import com.google.common.collect.Streams;
import com.google.inject.Inject;

import eu.fbk.sysmlv2.sysMLv2.ActionUsage;
import eu.fbk.sysmlv2.sysMLv2.AssertionAction;
import eu.fbk.sysmlv2.sysMLv2.Definition;
import eu.fbk.sysmlv2.sysMLv2.FeatureSpecialization;
import eu.fbk.sysmlv2.sysMLv2.NamedElement;
import eu.fbk.sysmlv2.sysMLv2.QualifiedNameExpression;
import eu.fbk.sysmlv2.sysMLv2.Redefinition;
import eu.fbk.sysmlv2.sysMLv2.ReferenceExpression;
import eu.fbk.sysmlv2.sysMLv2.Specialization;
import eu.fbk.sysmlv2.sysMLv2.StateUsage;
import eu.fbk.sysmlv2.sysMLv2.Subsetting;
import eu.fbk.sysmlv2.sysMLv2.SysMLv2Package;
import eu.fbk.sysmlv2.sysMLv2.Transition;
import eu.fbk.sysmlv2.sysMLv2.TriggerAction;
import eu.fbk.sysmlv2.sysMLv2.Typing;
import eu.fbk.sysmlv2.sysMLv2.Usage;
import eu.fbk.sysmlv2.sysMLv2.UsageChainExpression;
import eu.fbk.sysmlv2.sysMLv2.UsageReferenceExpression;

/**
 * This class contains custom scoping description.
 *
 * See https://www.eclipse.org/Xtext/documentation/303_runtime_concepts.html#scoping
 * on how and when to use it.
 */
public class SysMLv2ScopeProvider extends AbstractSysMLv2ScopeProvider {

	@Inject
	private IQualifiedNameProvider qualifiedNameProvider;

	private IScope getScopeForMembers(final EObject object) {
		return Scopes.scopeFor(EcoreUtil2.typeSelect(object.eContents(), NamedElement.class),
			QualifiedName.wrapper(element -> {
				final QualifiedName qualifiedName = qualifiedNameProvider.getFullyQualifiedName(element);
				if (qualifiedName == null) {
					return null;
				}
				return qualifiedName.getLastSegment();
			}),
			IScope.NULLSCOPE);
	}

	private List<IScope> recursivelyTraverseSpecializations(final EObject object, final boolean includeDirectChilds) {
		final var specializations = EcoreUtil2.typeSelect(object.eContents(), FeatureSpecialization.class);
		final List<IScope> scopes = new ArrayList<>();
		if (includeDirectChilds) {
			scopes.add(getScopeForMembers(object));
		}
		specializations.stream()
			.flatMap(s -> s.getReferences().stream().map(ReferenceExpression::getReferencedElement))
			.forEach(r -> scopes.addAll(recursivelyTraverseSpecializations(r, true)));
		return scopes;
	}

	private IScope buildScopeForElement(final EObject object, final boolean includeDirectChilds) {
		return CompositeScope.create(recursivelyTraverseSpecializations(object, includeDirectChilds));
	}

	private static IScope filterObjectsInScopeKeeping(final IScope scope, final Class<?>... typesToKeep) {
		return new FilteringScope(scope, description ->
			Arrays.stream(typesToKeep)
				  .anyMatch(t -> t.isInstance(description.getEObjectOrProxy())));
	}

	private IScope getEnrichedXtextScope(final EObject context, final EReference reference) {
		final EObject contextContainer = context.eContainer();
		final List<IScope> scopes = new ArrayList<>();
		EcoreUtil2.getAllContainers(contextContainer)
			.forEach(container -> scopes.addAll(recursivelyTraverseSpecializations(container, true)));
		scopes.add(super.getScope(context, reference));
		return CompositeScope.create(scopes);
	}

	@Override
	public IScope getScope(final EObject context, final EReference reference) {
		/*
		 * Custom scoping for feature specializations.
		 */
		if (context instanceof Redefinition) {
			final Usage redefiningUsage = (Usage) context.eContainer();
			if (redefiningUsage.eContainer() instanceof final AssertionAction assertionAction) {
				return buildScopeForElement(assertionAction.eContainer(), false);
			} else {
				return buildScopeForElement(redefiningUsage.eContainer(), false);
			}
		} else if (context instanceof Typing || context instanceof Specialization) {
			return filterObjectsInScopeKeeping(getEnrichedXtextScope(context, reference), Definition.class);
		} else if (context instanceof Subsetting) {
			return filterObjectsInScopeKeeping(getEnrichedXtextScope(context, reference), Usage.class);
		}

		/*
		 * Custom scoping for usage expressions.
		 */
		else if (context instanceof final UsageChainExpression expression) {
			final NamedElement body = expression.getBody().getReferencedElement();
			if (body instanceof final ActionUsage action && action.getMembers().size() == 1 &&
					action.getMembers().get(0) instanceof final TriggerAction triggerAction) {
				return Scopes.scopeFor(List.of(triggerAction.getPayload()));
			}
			return buildScopeForElement(body, true);
		} else if (context instanceof final UsageReferenceExpression ure && Streams.stream(EcoreUtil2.getAllContainers(ure)).anyMatch(FeatureSpecialization.class::isInstance)) {
			return buildScopeForElement(Streams.stream(EcoreUtil2.getAllContainers(ure)).filter(FeatureSpecialization.class::isInstance).findFirst().orElse(null).eContainer().eContainer(), true);
		}

		else if (context instanceof QualifiedNameExpression
			&& context.eContainer() instanceof FeatureSpecialization featureSpecialization) {
				return getScope(featureSpecialization, reference);
		}

		else if (context instanceof final Transition transition
				&& (reference == SysMLv2Package.Literals.TRANSITION__DESTINATION
						|| reference == SysMLv2Package.Literals.TRANSITION__SOURCE)) {
			final StateUsage stateMachine = EcoreUtil2.getContainerOfType(transition, StateUsage.class);
			return Scopes.scopeFor(EcoreUtil2.typeSelect(stateMachine.getMembers(), StateUsage.class));
		}

		/*
		 * Custom scoping for all other cases, i.e. default Xtext scoping enriched
		 * with all members inherited via the specializations of the containers of the
		 * element containing the reference.
		 */
		else {
			return getEnrichedXtextScope(context, reference);
		}
	}
}
