/*
 * SPDX-FileCopyrightText: 2024 Fondazione Bruno Kessler
 *
 * SPDX-FileContributor: Tommaso Fonda - initial API and implementation
 */
package eu.fbk.sysmlv2.services;

import static org.eclipse.xtext.EcoreUtil2.eAllContentsAsList;
import static org.eclipse.xtext.EcoreUtil2.typeSelect;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xtext.resource.DefaultLocationInFileProvider;
import org.eclipse.xtext.util.ITextRegion;

import eu.fbk.sysmlv2.sysMLv2.PortDefinition;
import eu.fbk.sysmlv2.util.SysMLv2Util;

public class SysMLv2LocationInFileProvider extends DefaultLocationInFileProvider {

	@Override
	protected EStructuralFeature getIdentifierFeature(EObject obj) {
		final EClass eClass = obj.eClass();
		EStructuralFeature result = eClass.getEStructuralFeature("name");
		if (result != null && obj.eGet(result) != null) {
			return result;
		}
		result = eClass.getEStructuralFeature("shorthandRedefinition");
		return result != null ? result : eClass.getEStructuralFeature("id");
	}

	@Override
	protected ITextRegion getTextRegion(EObject obj, boolean isSignificant) {
		if (obj instanceof final PortDefinition portDefinition && SysMLv2Util.isConjugatedPort(portDefinition)) {
			final String realName = portDefinition.getName().substring(1);
			obj = typeSelect(eAllContentsAsList(portDefinition.eResource()), PortDefinition.class).stream()
				.filter(portDef -> realName.equals(portDef.getName()))
				.findAny().orElseGet(() -> portDefinition);
		}
		return super.getTextRegion(obj, isSignificant);
	}

}
