package eu.fbk.sysmlv2.util;

import java.util.ArrayList;
import java.util.List;

import org.eclipse.xtext.EcoreUtil2;

import eu.fbk.sysmlv2.sysMLv2.AttributeUsage;
import eu.fbk.sysmlv2.sysMLv2.Definition;
import eu.fbk.sysmlv2.sysMLv2.PartUsage;
import eu.fbk.sysmlv2.sysMLv2.util.SysMLv2Switch;

public class SysMLv2FeatureChainSwitch extends SysMLv2Switch<Object> {

	private final StringBuilder prefixBuilder = new StringBuilder();
	private final List<String> observablesFeatureChains = new ArrayList<>();

	public List<String> getObservablesFeatureChains(PartUsage systemComponent) {
		doSwitch(systemComponent);
		return observablesFeatureChains;
	}

	@Override
	public Object casePartUsage(PartUsage partUsage) {
		if (SysMLv2Util.isSystemPartUsage(partUsage)) {
			prefixBuilder.setLength(0);
			observablesFeatureChains.clear();
		} else {
			prefixBuilder.append(".");
		}
		prefixBuilder.append(partUsage.getName());
		Definition definition = SysMLv2Util.getType(partUsage);
		EcoreUtil2.typeSelect(definition.getMembers(), AttributeUsage.class).stream()
			.filter(SysMLv2Util::isObservableVariable)
			.map(observable -> prefixBuilder.toString() + "." + observable.getName())
			.forEach(observablesFeatureChains::add);
		EcoreUtil2.typeSelect(definition.getMembers(), PartUsage.class).forEach(this::casePartUsage);
		final int trimmedLength = prefixBuilder.length() - (partUsage.getName().length() + 1);
		if (trimmedLength > 0) {
			prefixBuilder.setLength(trimmedLength);
		}
		return null;
	}

}
