/*
 * SPDX-FileCopyrightText: 2024 Fondazione Bruno Kessler
 *
 * SPDX-FileContributor: Tommaso Fonda - initial API and implementation
 */
/*
 * generated by Xtext 2.34.0
 */
package eu.fbk.sysmlv2.validation;

import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.validation.Check;

import eu.fbk.sysmlv2.sysMLv2.ActionUsage;
import eu.fbk.sysmlv2.sysMLv2.Assignment;
import eu.fbk.sysmlv2.sysMLv2.AttributeUsage;
import eu.fbk.sysmlv2.sysMLv2.Binding;
import eu.fbk.sysmlv2.sysMLv2.Calculation;
import eu.fbk.sysmlv2.sysMLv2.ConnectionUsage;
import eu.fbk.sysmlv2.sysMLv2.Definition;
import eu.fbk.sysmlv2.sysMLv2.DirectedElement;
import eu.fbk.sysmlv2.sysMLv2.Direction;
import eu.fbk.sysmlv2.sysMLv2.EnumDefinition;
import eu.fbk.sysmlv2.sysMLv2.EnumUsage;
import eu.fbk.sysmlv2.sysMLv2.Feature;
import eu.fbk.sysmlv2.sysMLv2.Multiplicity;
import eu.fbk.sysmlv2.sysMLv2.Package;
import eu.fbk.sysmlv2.sysMLv2.PartDefinition;
import eu.fbk.sysmlv2.sysMLv2.PartUsage;
import eu.fbk.sysmlv2.sysMLv2.PortUsage;
import eu.fbk.sysmlv2.sysMLv2.ReferenceExpression;
import eu.fbk.sysmlv2.sysMLv2.SendUsage;
import eu.fbk.sysmlv2.sysMLv2.Specialization;
import eu.fbk.sysmlv2.sysMLv2.Subsetting;
import eu.fbk.sysmlv2.sysMLv2.SuccessionNode;
import eu.fbk.sysmlv2.sysMLv2.SysMLv2Package;
import eu.fbk.sysmlv2.sysMLv2.Transition;
import eu.fbk.sysmlv2.sysMLv2.TriggerAction;
import eu.fbk.sysmlv2.sysMLv2.Typing;
import eu.fbk.sysmlv2.sysMLv2.Usage;
import eu.fbk.sysmlv2.util.SysMLv2Util;

/**
 * This class contains custom validation rules.
 *
 * See https://www.eclipse.org/Xtext/documentation/303_runtime_concepts.html#validation
 */
public class SysMLv2Validator extends AbstractSysMLv2Validator {

	public static final String INVALID_ASTERISK_IN_MULTIPLICITY = "invalidAsteriskInMultiplicity";

	@Check
	private void checkAsteriskInMultiplicity(Multiplicity multiplicity) {
		int lowerBound = multiplicity.getLowerBound();
		if (lowerBound == -1 && multiplicity.getUpperBound() != null) {
			error("Invalid asterisk usage in multiplicity.", multiplicity.eContainer(),
				SysMLv2Package.Literals.USAGE__MULTIPLICITY, INVALID_ASTERISK_IN_MULTIPLICITY);
		}
	}

	public static final String INVALID_SPECIALIZATION = "invalidSpecialization";

	@Check
	private void checkSpecialization(Specialization specialization) {
		specialization.getReferences().stream().map(ReferenceExpression::getReferencedElement).forEach(r -> {
			if (!(r instanceof Definition)) {
				error("A definition may only specialize other definitions.",
						specialization.eContainer(),
						SysMLv2Package.Literals.DEFINITION__SPECIALIZATION,
						INVALID_SPECIALIZATION);
			}
		});
	}

	public static final String INVALID_SUBSETTING = "invalidSubsetting";

	@Check
	private void checkSubsetting(Subsetting subsetting) {
		subsetting.getReferences().stream().map(ReferenceExpression::getReferencedElement).forEach(r -> {
			if (!(r instanceof Usage)) {
				error("A usage may only subset other usages.",
						subsetting.eContainer(),
						SysMLv2Package.Literals.USAGE__SUBSETTING,
						INVALID_SUBSETTING);
			}
		});
	}

	public static final String INVALID_TYPING = "invalidTyping";

	@Check
	private void invalidTyping(Typing typing) {
		typing.getReferences().stream().map(ReferenceExpression::getReferencedElement).forEach(r -> {
			if (!(r instanceof Definition)) {
				error("A usage may only be defined by a definition.",
						typing.eContainer(),
						SysMLv2Package.Literals.TYPED_ELEMENT__TYPING,
						INVALID_SUBSETTING);
			}
		});
	}

	public static final String INVALID_ASSIGNMENT = "invalidAssignment";

	@Check
	private void checkAssignment(Assignment assignment) {
		if (assignment.getValue().isBinding()) {
			error("An assignment cannot specify a binding. "
				+ "Only the assignment (':=') operator is allowed.",
				assignment.getValue(),
				SysMLv2Package.Literals.VALUE__BINDING,
				INVALID_ASSIGNMENT);
		} else if (assignment.getValue().isDefault()) {
			error("An assignment cannot specify a default value. "
				+ "Only the assignment (':=') operator is allowed.",
				assignment.getValue(),
				SysMLv2Package.Literals.VALUE__DEFAULT,
				INVALID_ASSIGNMENT);
	    }
	}

	public static final String INVALID_CONNECTION_USAGE_SOURCE_DIRECTION = "invalidConnectionUsageSourceDirection";

	@Check
	private void checkConnectionUsageSourceDirection(ConnectionUsage connectionUsage) {
		final Package pkg = EcoreUtil2.getContainerOfType(connectionUsage, Package.class);
		if (pkg.isStandard()) {
			return;
		}
		if (connectionUsage.getSource() instanceof final ReferenceExpression reference) {
			final var source = reference.getReferencedElement();
			if (source instanceof final DirectedElement sourceAsDirectedElement) {
				if (!Direction.OUT.equals(sourceAsDirectedElement.getDirection())) {
					error("The source of a connection usage shall be an output element.",
							SysMLv2Package.Literals.CONNECTION_ELEMENT__SOURCE,
							INVALID_CONNECTION_USAGE_SOURCE_DIRECTION);
				}
			}
		}
	}

	public static final String INVALID_CONNECTION_USAGE_TARGET_DIRECTION = "invalidConnectionUsageTargetDirection";

	@Check
	private void checkConnectionUsageTargetDirection(ConnectionUsage connectionUsage) {
		final Package pkg = EcoreUtil2.getContainerOfType(connectionUsage, Package.class);
		if (pkg.isStandard()) {
			return;
		}
		final var target = connectionUsage.getTarget().getReferencedElement();
		if (target instanceof final DirectedElement targetAsDirectedElement) {
			if (!Direction.IN.equals(targetAsDirectedElement.getDirection())) {
				error("The target of a connection usage shall be an input element.",
						SysMLv2Package.Literals.CONNECTION_ELEMENT__TARGET,
						INVALID_CONNECTION_USAGE_TARGET_DIRECTION);
			}
		}
	}

	public static final String INVALID_BINDING_SOURCE = "invalidBindingSource";

	@Check
	private void checkBindingSource(Binding binding) {
		final Package pkg = EcoreUtil2.getContainerOfType(binding, Package.class);
		if (pkg.isStandard()) {
			return;
		}
		if (!((binding.getSource() instanceof final ReferenceExpression reference) &&
			(reference.getReferencedElement() instanceof AttributeUsage ||
					reference.getReferencedElement() instanceof Feature ||
					reference.getReferencedElement() instanceof PortUsage))) {
			error("A binding's source shall only be an attribute, feature or port usage.",
					SysMLv2Package.Literals.CONNECTION_ELEMENT__SOURCE);
		}
	}

	public static final String INVALID_BINDING_TARGET = "invalidBindingSource";

	@Check
	private void checkBindingTarget(Binding binding) {
		final Package pkg = EcoreUtil2.getContainerOfType(binding, Package.class);
		if (pkg.isStandard()) {
			return;
		}
		final ReferenceExpression reference = binding.getTarget();
		if (!(reference.getReferencedElement() instanceof AttributeUsage ||
					reference.getReferencedElement() instanceof Feature ||
					reference.getReferencedElement() instanceof PortUsage)) {
			error("A binding's target shall only be an attribute, feature or port usage.",
					SysMLv2Package.Literals.CONNECTION_ELEMENT__TARGET);
		}
	}

	public static final String INVALID_BINDING_DIRECTIONS = "invalidBindingDirections";

	@Check
	private void checkBindingDirections(Binding binding) {
		final Package pkg = EcoreUtil2.getContainerOfType(binding, Package.class);
		if (pkg.isStandard()) {
			return;
		}
		if (binding.getSource() instanceof final ReferenceExpression sourceReference) {
			if (sourceReference.getReferencedElement() instanceof final DirectedElement source &&
					binding.getTarget().getReferencedElement() instanceof final DirectedElement target) {
				if (!source.getDirection().equals(target.getDirection())) {
					error("Source and target of a binding shall have the same direction",
							SysMLv2Package.Literals.CONNECTION_ELEMENT__SOURCE);
					error("Source and target of a binding shall have the same direction",
							SysMLv2Package.Literals.CONNECTION_ELEMENT__TARGET);
				}
			}
		}
	}

	public static final String INVALID_ASSIGNMENT_TO_INPUT_FEATURE = "invalidAssignmentToInputFeature";

	@Check
	private void checkAssignedFeature(Assignment assignment) {
		if (assignment.getElement().getReferencedElement() instanceof final DirectedElement directedElement
				&& Direction.IN.equals(directedElement.getDirection())) {
			error("Cannot assign a value to an input feature.",
					SysMLv2Package.Literals.ASSIGNMENT__ELEMENT);
		}
	}

	public static final String INVALID_SEND_USAGE_TRANSPORT = "invalidSendUsageTransport";

	@Check
	private void checkSendUsageTransport(SendUsage sendUsage) {
		if (!(sendUsage.getTransport().getReferencedElement() instanceof PortUsage)) {
			error("A SendUsage must specify a PortUsage as its transport.",
					SysMLv2Package.Literals.SEND_USAGE__TRANSPORT);
		}
	}

	public static final String UNSUPPORTED_ENUM_DEFINITION_IN_CALCULATION = "unsupportedEnumDefinitionInCalculation";

	@Check
	private void checkEnumDefinitionInCalculation(Calculation calculation) {
		calculation.getMembers().stream()
			.filter(DirectedElement.class::isInstance).map(DirectedElement.class::cast)
			.filter(parameter -> Direction.IN.equals(parameter.getDirection()))
			.map(SysMLv2Util::getType)
			.filter(EnumDefinition.class::isInstance).map(EnumDefinition.class::cast)
			.forEach(enumDefinition -> enumDefinition.getMembers().stream()
					.filter(EnumUsage.class::isInstance).map(EnumUsage.class::cast)
					.filter(enumUsage -> enumUsage.getValue() == null)
					.forEach(enumUsage -> warning("This enum should be bound to an integer value using the '=' operator.", enumUsage,
							SysMLv2Package.Literals.NAMED_ELEMENT__NAME)));
	}

	public static final String INVALID_DURATIVE_TRANSITION = "invalidDurativeTransition";

	@Check
	private void checkDurativeTransition(Transition transition) {
		if (SysMLv2Util.isDurative(transition)) {
			final var actFeature = SysMLv2Util.getMemberByName(transition, Usage.class, "act");
			if (actFeature == null) {
				error("A durative transition shall contain a feature named 'act'.",
						SysMLv2Package.Literals.CONTAINER__MEMBERS);
			} else if (actFeature.getValue() == null ||
					!(actFeature.getValue().getExpression() instanceof final ReferenceExpression referenceExpression) ||
					!(referenceExpression.getReferencedElement() instanceof final PartUsage partUsage) ||
					!SysMLv2Util.partDefinitionIsActivity((PartDefinition) SysMLv2Util.getType(partUsage))) {
				error("The 'act' feature in a durative transition shall be bound with the '=' operator"
						+ " to a PartUsage representing an activity.", actFeature, SysMLv2Package.Literals.USAGE__VALUE);
			}

		}
	}

	public static final String INVALID_SETTER_ACTION = "invalidSetterAction";

	@Check
	private void checkSetterAction(ActionUsage actionUsage) {
		final Package pkg = EcoreUtil2.getContainerOfType(actionUsage, Package.class);
		if (pkg.isLibrary()) {
			return;
		}
		final var type = SysMLv2Util.getType(actionUsage);
		if (type != null && type.getName().equals("Setter")) {
			if (actionUsage.getMembers().size() == 0 || !(actionUsage.getMembers().get(0) instanceof ActionUsage)) {
				error("A Setter action shall contain an action usage as its first member.",
						SysMLv2Package.Literals.CONTAINER__MEMBERS);
				return;
			}
			final ActionUsage action = (ActionUsage) actionUsage.getMembers().get(0);
			if (action.getMembers().isEmpty() || !(action.getMembers().get(0) instanceof TriggerAction)) {
				error("A Setter action shall contain an action usage containing a trigger ('accept' action) as its first member.",
						action, SysMLv2Package.Literals.CONTAINER__MEMBERS);
				return;
			}
			if (actionUsage.getMembers().size() == 1 || !(actionUsage.getMembers().get(1) instanceof SuccessionNode) ||
					!(((SuccessionNode) actionUsage.getMembers().get(1)).getNode() instanceof Assignment)) {
				error("A Setter action shall contain a succession with an assignment ('then assign') as its second member.",
						SysMLv2Package.Literals.CONTAINER__MEMBERS);
				return;
			}
		}
	}

}
