function [O_R_compressed, C_R_compressed, O_Q_compressed, C_Q_compressed] = get_reachability_matrices(R, abstract_regions, num_locations, location_regions_emptiness, options, params, t_max_avoidance)
%GET_REACHABILITY_MATRICES Summary of this function goes here
%   Detailed explanation goes here

len_matrices = round(t_max_avoidance / options.timeStep) - 1;
for index_R_simulation = 1 : length(R)
    O_R{index_R_simulation} = zeros(len_matrices, length(abstract_regions));
    C_R{index_R_simulation} = ones(len_matrices, length(abstract_regions));
    O_Q{index_R_simulation} = zeros(len_matrices, num_locations);
    C_Q{index_R_simulation} = ones(len_matrices, num_locations);
    
    for index_region_cora = 1 : length(R(index_R_simulation,1).timeInterval.set)
        if R(index_R_simulation,1).timeInterval.time{index_region_cora}.sup < t_max_avoidance
            region_cora = R(index_R_simulation,1).timeInterval.set{index_region_cora};
            index_this_set_inf_rational = R(index_R_simulation,1).timeInterval.time{index_region_cora}.inf / options.timeStep;
            index_this_set_sup_rational = R(index_R_simulation,1).timeInterval.time{index_region_cora}.sup / options.timeStep;
            index_this_set_inf = round(index_this_set_inf_rational) + 1;
            index_this_set_sup = round(index_this_set_sup_rational);
            assert(abs(index_this_set_inf - index_this_set_inf_rational - 1) + abs(index_this_set_sup_rational - index_this_set_sup) < 1e-9, "ERROR IN INDEX MATRICES")
            for index_abstract_region = 1 : length(abstract_regions)
                abstract_region = abstract_regions{index_abstract_region};
                if ismember(index_abstract_region, location_regions_emptiness{R(index_R_simulation,1).loc})
                    ll = ludo_intersects_conservative(region_cora, abstract_region);
                    mm = ludo_is_contained_in_conservative(region_cora, abstract_region);
                    for index_mat = index_this_set_inf : min([index_this_set_sup, params.tFinal / options.timeStep, len_matrices])
                        O_R{index_R_simulation}(index_mat, index_abstract_region) = ll;
                        C_R{index_R_simulation}(index_mat, index_abstract_region) = mm;
                    end
                else
                    for index_mat = index_this_set_inf : min([index_this_set_sup, params.tFinal / options.timeStep, len_matrices])
                        O_R{index_R_simulation}(index_mat, index_abstract_region) = 0;
                        C_R{index_R_simulation}(index_mat, index_abstract_region) = 0;
                    end
                end
            end
    
            for index_location = 1 : num_locations
                if index_location ~= R(index_R_simulation, 1).loc
                    for index_mat = index_this_set_inf : min([index_this_set_sup, params.tFinal / options.timeStep, len_matrices])
                        C_Q{index_R_simulation}(index_mat, index_location) = 0;
                    end
                else
                    for index_mat = index_this_set_inf : min([index_this_set_sup, params.tFinal / options.timeStep, len_matrices])
                        O_Q{index_R_simulation}(index_mat, index_location) = 1;
                    end
                end
            end
            
        end
    
    end
end
O_R_merged = merge_matrix_over(O_R);
C_R_merged = merge_matrix_under(C_R);
O_Q_merged = merge_matrix_over(O_Q);
C_Q_merged = merge_matrix_under(C_Q);





[O_R_compressed, C_R_compressed, O_Q_compressed, C_Q_compressed] = compress_matrices(O_R_merged, C_R_merged, O_Q_merged, C_Q_merged);

end