function Z = zonotope_from_interval(index_const_coord, x, y, z, w)
%ZONOTOPE_FROM_INTERVAL Summary of this function goes here
%   Detailed explanation goes here
if not( any( isinf( [x; y; z] ) ) )
    if index_const_coord == 1
        center_x = (x(2) + x(1))/2;
        center_y = (y(2) + y(1))/2;
        center_z = (z(2) + z(1))/2;
        Z = zonotope([w; center_x; center_y; center_z], diag([0; x(2)-center_x; y(2)-center_y; z(2)-center_z]));
    elseif index_const_coord == 2
        center_x = (x(2) + x(1))/2;
        center_y = (y(2) + y(1))/2;
        center_z = (z(2) + z(1))/2;
        Z = zonotope([center_x; w; center_y; center_z], diag([x(2)-center_x; 0; y(2)-center_y; z(2)-center_z]));
    end
else
    if index_const_coord == 1
        A = [-1 0 0 0; 1 0 0 0];
        b = [-w; w];
        if x(1) ~= - Inf
            A = [A; 0 -1 0 0];
            b = [b; -(x(1))];
        end
        if x(2) ~= Inf
            A = [A; 0 1 0 0];
            b = [b; (x(2))];
        end
        if y(1) ~= - Inf
            A = [A; 0 0 -1 0];
            b = [b; -(y(1))];
        end
        if y(2) ~= Inf
            A = [A; 0 0 1 0];
            b = [b; (y(2))];
        end
        if z(1) ~= - Inf
            A = [A; 0 0 0 -1];
            b = [b; -(z(1))];
        end
        if z(2) ~= Inf
            A = [A; 0 0 0 1];
            b = [b; (z(2))];
        end
    elseif index_const_coord == 2
        A = [0 -1 0 0; 0 1 0 0];
        b = [-w; w];
        if x(1) ~= - Inf
            A = [A; -1 0 0 0];
            b = [b; -(x(1))];
        end
        if x(2) ~= Inf
            A = [A; 1 0 0 0];
            b = [b; (x(2))];
        end
        if y(1) ~= - Inf
            A = [A; 0 0 -1 0];
            b = [b; -(y(1))];
        end
        if y(2) ~= Inf
            A = [A; 0 0 1 0];
            b = [b; (y(2))];
        end
        if z(1) ~= - Inf
            A = [A; 0 0 0 -1];
            b = [b; -(z(1))];
        end
        if z(2) ~= Inf
            A = [A; 0 0 0 1];
            b = [b; (z(2))];
        end
    end
    Z = polytope(A,b);
end

